/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.PipelineBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectForm {
    private final String name;
    private final String result;
    private final String health;
    private final String url;
    private final List<ProjectForm> dependencies;

    public ProjectForm(String name) {
        this.name = name;
        this.result = "";
        this.health = "";
        this.url = "";
        this.dependencies = new ArrayList<ProjectForm>();
    }

    public ProjectForm(AbstractProject<?, ?> project) {
        PipelineBuild pipelineBuild = new PipelineBuild((AbstractBuild)project.getLastBuild(), project, null);
        this.name = pipelineBuild.getProject().getName();
        this.result = pipelineBuild.getCurrentBuildResult();
        this.health = pipelineBuild.getProject().getBuildHealth().getIconUrl().replaceAll("\\.gif", "\\.png");
        this.url = pipelineBuild.getProjectURL();
        this.dependencies = new ArrayList<ProjectForm>();
        for (AbstractProject dependency : project.getDownstreamProjects()) {
            this.dependencies.add(new ProjectForm(dependency));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHealth() {
        return this.health;
    }

    public String getResult() {
        return this.result;
    }

    public String getUrl() {
        return this.url;
    }

    public List<ProjectForm> getDependencies() {
        return this.dependencies;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectForm other = (ProjectForm)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

