/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline.trigger;

import au.com.centrumsystems.hudson.plugin.buildpipeline.trigger.DownstreamDependency;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Messages;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPipelineTrigger
extends Notifier
implements DependecyDeclarer {
    private String downstreamProjectNames;

    public String getDownstreamProjectNames() {
        return this.downstreamProjectNames;
    }

    public void setDownstreamProjectNames(String downstreamProjectNames) {
        this.downstreamProjectNames = downstreamProjectNames;
    }

    @DataBoundConstructor
    public BuildPipelineTrigger(String downstreamProjectNames) {
        if (downstreamProjectNames == null) {
            throw new IllegalArgumentException();
        }
        this.setDownstreamProjectNames(downstreamProjectNames);
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (this.downstreamProjectNames != null && this.downstreamProjectNames.length() > 0) {
            Iterator i$ = Items.fromNameList((String)this.downstreamProjectNames, AbstractProject.class).iterator();
            while (i$.hasNext()) {
                AbstractProject o;
                AbstractProject downstream = o = (AbstractProject)i$.next();
                graph.addDependency((DependencyGraph.Dependency)this.createDownstreamDependency(owner, downstream));
            }
        }
    }

    private DownstreamDependency createDownstreamDependency(AbstractProject<?, ?> owner, AbstractProject<?, ?> downstream) {
        return new DownstreamDependency(owner, downstream);
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    public boolean onDownstreamProjectRenamed(String oldName, String newName) {
        boolean changed = false;
        String[] existingDownstreamProjects = this.getDownstreamProjectNames().split(",");
        for (int i = 0; i < existingDownstreamProjects.length; ++i) {
            if (!existingDownstreamProjects[i].trim().equals(oldName)) continue;
            existingDownstreamProjects[i] = newName;
            changed = true;
        }
        if (changed) {
            StringBuilder newDownstreamProjects = new StringBuilder();
            for (int i = 0; i < existingDownstreamProjects.length; ++i) {
                if (existingDownstreamProjects[i] == null) continue;
                if (newDownstreamProjects.length() > 0) {
                    newDownstreamProjects.append(',');
                }
                newDownstreamProjects.append(existingDownstreamProjects[i].trim());
            }
            this.setDownstreamProjectNames(newDownstreamProjects.toString());
        }
        return changed;
    }

    public boolean onDownstreamProjectDeleted(String oldName) {
        return this.onDownstreamProjectRenamed(oldName, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Build Pipeline Plugin -> Manually Execute Downstream Project";
        }

        public String getHelpFile() {
            return "/descriptor/au.com.centrumsystems.hudson.plugin.buildpipeline.trigger.BuildPipelineTrigger/help/buildPipeline.html";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new BuildPipelineTrigger(formData.getString("downstreamProjectNames"));
        }

        public FormValidation doCheckDownstreamProjectNames(@QueryParameter(value="downstreamProjectNames") String value) {
            StringTokenizer tokens = new StringTokenizer(Util.fixNull((String)value), ",");
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                Item item = Hudson.getInstance().getItemByFullName(projectName, Item.class);
                if (item == null) {
                    return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)projectName, (Object)AbstractProject.findNearest((String)projectName).getName()));
                }
                if (item instanceof AbstractProject) continue;
                return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)projectName));
            }
            return FormValidation.ok();
        }

        @Extension
        public static final class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    BuildPipelineTrigger bpTrigger = (BuildPipelineTrigger)p.getPublishersList().get(BuildPipelineTrigger.class);
                    if (bpTrigger == null) continue;
                    boolean changed = false;
                    changed = bpTrigger.onDownstreamProjectRenamed(oldName, newName);
                    if (!changed) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        Logger.getLogger(ItemListenerImpl.class.getName()).log(Level.WARNING, "Failed to persist project BuildPipelineTrigger setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }

            public void onDeleted(Item item) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    String oldName = item.getName();
                    BuildPipelineTrigger bpTrigger = (BuildPipelineTrigger)p.getPublishersList().get(BuildPipelineTrigger.class);
                    if (bpTrigger == null) continue;
                    boolean changed = false;
                    if (bpTrigger.onDownstreamProjectDeleted(oldName)) {
                        changed = true;
                    }
                    if (!changed) continue;
                    try {
                        if (bpTrigger.getDownstreamProjectNames().isEmpty()) {
                            p.getPublishersList().remove((Object)bpTrigger);
                        }
                        p.save();
                    }
                    catch (IOException e) {
                        Logger.getLogger(ItemListenerImpl.class.getName()).log(Level.WARNING, "Failed to persist project BuildPipelineTrigger setting during remove of " + oldName, e);
                    }
                }
            }
        }
    }
}

