/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.BuildForm;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPipelineForm {
    private final Map<Integer, Map<Integer, ProjectForm>> projectGrid = new HashMap();
    private final List<Map<Integer, Map<Integer, BuildForm>>> buildGrids;

    public BuildPipelineForm(ProjectForm projectForm, BuildForm ... buildForms) {
        this.placeProjectInGrid(0, 0, projectForm);
        this.buildGrids = new ArrayList();
        for (BuildForm buildForm : buildForms) {
            HashMap buildGrid = new HashMap();
            this.placeBuildInGrid(0, 0, buildForm, buildGrid);
            this.buildGrids.add(buildGrid);
        }
    }

    public BuildPipelineForm(ProjectForm projectForm, List<BuildForm> buildForms) {
        this(projectForm, buildForms.toArray(new BuildForm[buildForms.size()]));
    }

    private void placeProjectInGrid(int startingRow, int startingColumn, ProjectForm projectForm) {
        int row = startingRow;
        if (this.projectGrid.get(row) == null) {
            this.projectGrid.put(row, new HashMap());
        }
        ((Map)this.projectGrid.get(row)).put(startingColumn, projectForm);
        int childrensColumn = startingColumn + 1;
        for (ProjectForm downstreamProject : projectForm.getDependencies()) {
            this.placeProjectInGrid(row, childrensColumn, downstreamProject);
            ++row;
        }
    }

    private void placeBuildInGrid(int startingRow, int startingColumn, BuildForm buildForm, Map<Integer, Map<Integer, BuildForm>> buildGrid) {
        int row = startingRow;
        if (buildGrid.get(row) == null) {
            buildGrid.put(row, new HashMap());
        }
        buildGrid.get(row).put(startingColumn, buildForm);
        int childrensColumn = startingColumn + 1;
        for (BuildForm downstreamProject : buildForm.getDependencies()) {
            this.placeBuildInGrid(row, childrensColumn, downstreamProject, buildGrid);
            ++row;
        }
    }

    public Map<Integer, Map<Integer, ProjectForm>> getProjectGrid() {
        return this.projectGrid;
    }

    public Integer getGridWidth() {
        int maxHeight = 0;
        for (Integer key : this.projectGrid.keySet()) {
            for (Integer innerKey : ((Map)this.projectGrid.get(key)).keySet()) {
                if (maxHeight >= innerKey) continue;
                maxHeight = innerKey;
            }
        }
        return maxHeight + 1;
    }

    public Integer getGridHeight() {
        return this.projectGrid.keySet().size();
    }

    public List<Map<Integer, Map<Integer, BuildForm>>> getBuildGrids() {
        return this.buildGrids;
    }
}

