/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline.trigger;

import au.com.centrumsystems.hudson.plugin.buildpipeline.trigger.DownstreamDependency;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Items;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.Iterator;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPipelineTrigger
extends Notifier
implements DependecyDeclarer {
    private String downstreamProjectNames;

    public String getDownstreamProjectNames() {
        return this.downstreamProjectNames;
    }

    public void setDownstreamProjectNames(String downstreamProjectNames) {
        this.downstreamProjectNames = downstreamProjectNames;
    }

    @DataBoundConstructor
    public BuildPipelineTrigger(String downstreamProjectNames) {
        if (downstreamProjectNames == null) {
            throw new IllegalArgumentException();
        }
        this.setDownstreamProjectNames(downstreamProjectNames);
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (this.downstreamProjectNames != null && this.downstreamProjectNames.length() > 0) {
            Iterator i$ = Items.fromNameList((String)this.downstreamProjectNames, AbstractProject.class).iterator();
            while (i$.hasNext()) {
                AbstractProject o;
                AbstractProject downstream = o = (AbstractProject)i$.next();
                graph.addDependency((DependencyGraph.Dependency)this.createDownstreamDependency(owner, downstream));
            }
        }
    }

    private DownstreamDependency createDownstreamDependency(AbstractProject<?, ?> owner, AbstractProject<?, ?> downstream) {
        return new DownstreamDependency(owner, downstream);
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    public boolean onDownstreamProjectRenamed(String oldName, String newName) {
        boolean changed = false;
        String[] existingDownstreamProjects = new String[5];
        if (this.getDownstreamProjectNames() != null) {
            existingDownstreamProjects = this.getDownstreamProjectNames().split(",");
            for (int i = 0; i < existingDownstreamProjects.length; ++i) {
                if (!existingDownstreamProjects[i].trim().equals(oldName)) continue;
                existingDownstreamProjects[i] = newName;
                changed = true;
            }
        }
        if (changed) {
            StringBuilder newDownstreamProjects = new StringBuilder();
            for (int i = 0; i < existingDownstreamProjects.length; ++i) {
                if (existingDownstreamProjects[i] == null) continue;
                if (newDownstreamProjects.length() > 0) {
                    newDownstreamProjects.append(',');
                }
                newDownstreamProjects.append(existingDownstreamProjects[i].trim());
            }
            this.setDownstreamProjectNames(newDownstreamProjects.toString());
        }
        return changed;
    }

    public boolean onDownstreamProjectDeleted(String oldName) {
        return this.onDownstreamProjectRenamed(oldName, null);
    }
}

