/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.PipelineBuild;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildForm {
    private String revision = "";
    private String name = "";
    private String status = "";
    private String url = "";
    private String duration = "";
    private String upstreamProjectName = "";
    private String upstreamBuildNumber = "";
    private String projectName = "";
    private boolean manual;
    private Date startTime;
    private List<BuildForm> dependencies = new ArrayList();

    public BuildForm(PipelineBuild pipelineBuild) {
        this.name = pipelineBuild.getBuildDescription();
        this.status = pipelineBuild.getCurrentBuildResult();
        this.revision = pipelineBuild.getScmRevision();
        this.url = pipelineBuild.getBuildResultURL();
        this.duration = pipelineBuild.getBuildDuration();
        this.manual = pipelineBuild.isManual();
        if (pipelineBuild.getUpstreamPipelineBuild() != null) {
            if (pipelineBuild.getUpstreamPipelineBuild().getProject() != null) {
                this.projectName = pipelineBuild.getProject().getName();
                this.upstreamProjectName = pipelineBuild.getUpstreamPipelineBuild().getProject().getName();
            }
            if (pipelineBuild.getUpstreamBuild() != null) {
                this.upstreamBuildNumber = String.valueOf(pipelineBuild.getUpstreamBuild().getNumber());
            }
        }
        this.dependencies = new ArrayList();
        for (PipelineBuild downstream : pipelineBuild.getDownstreamPipeline()) {
            this.dependencies.add(new BuildForm(downstream));
        }
        this.startTime = pipelineBuild.getStartTime();
    }

    public BuildForm(String name) {
        this.name = name;
        this.dependencies = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDuration() {
        return this.duration;
    }

    public boolean isManual() {
        return this.manual;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getUpstreamBuildNumber() {
        return this.upstreamBuildNumber;
    }

    public String getUpstreamProjectName() {
        return this.upstreamProjectName;
    }

    public String getStartTime() {
        String formattedStartTime = "";
        if (this.startTime != null) {
            formattedStartTime = DateFormat.getTimeInstance(0).format(this.startTime);
        }
        return formattedStartTime;
    }

    public String getStartDate() {
        String formattedStartTime = "";
        if (this.startTime != null) {
            formattedStartTime = DateFormat.getDateInstance(2).format(this.startTime);
        }
        return formattedStartTime;
    }

    public List<BuildForm> getDependencies() {
        return this.dependencies;
    }

    public String getShortRevision() {
        String shortRevision = this.revision.length() > 22 ? this.revision.substring(0, 22) + "..." : this.revision;
        return shortRevision;
    }
}

