/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.util;

import au.com.centrumsystems.hudson.plugin.util.ProjectUtil;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildUtil {
    public static AbstractBuild<?, ?> getDownstreamBuild(AbstractProject<?, ?> downstreamProject, AbstractBuild<?, ?> upstreamBuild) {
        if (downstreamProject != null && upstreamBuild != null) {
            for (AbstractBuild innerBuild : downstreamProject.getBuilds()) {
                for (CauseAction action : innerBuild.getActions(CauseAction.class)) {
                    for (Cause cause : action.getCauses()) {
                        Cause.UpstreamCause upstreamCause;
                        if (!(cause instanceof Cause.UpstreamCause) || !(upstreamCause = (Cause.UpstreamCause)cause).getUpstreamProject().equals(upstreamBuild.getProject().getName()) || upstreamCause.getUpstreamBuild() != upstreamBuild.getNumber()) continue;
                        return innerBuild;
                    }
                }
            }
        }
        return null;
    }

    public static Action getAllBuildParametersAction(AbstractBuild<?, ?> upstreamBuild, AbstractProject<?, ?> downstreamProject) {
        ParametersAction dsProjectParametersAction = ProjectUtil.getProjectParametersAction(downstreamProject);
        ParametersAction usBuildParametersAction = BuildUtil.getBuildParametersAction(upstreamBuild);
        return BuildUtil.mergeParameters(usBuildParametersAction, dsProjectParametersAction);
    }

    public static ParametersAction getBuildParametersAction(AbstractBuild<?, ?> build) {
        ParametersAction buildParametersAction = null;
        if (build != null) {
            for (Action nextAction : build.getActions()) {
                if (!(nextAction instanceof ParametersAction)) continue;
                buildParametersAction = (ParametersAction)nextAction;
            }
        }
        return buildParametersAction;
    }

    public static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        if (base != null) {
            for (ParameterValue param : base.getParameters()) {
                params.put(param.getName(), param);
            }
        }
        if (overlay != null) {
            for (ParameterValue param : overlay.getParameters()) {
                params.put(param.getName(), param);
            }
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }
}

