/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.triggers.SafeTimerTask;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.TimerTask;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTimeoutWrapper
extends BuildWrapper {
    public int timeoutMinutes;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public BuildWrapper.Environment setUp(final AbstractBuild build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EnvironmentImpl
        extends BuildWrapper.Environment {
            private final TimerTask task;

            public EnvironmentImpl() {
                super((BuildWrapper)BuildTimeoutWrapper.this);
                this.task = new SafeTimerTask(){

                    public void doRun() {
                        listener.getLogger().println("Build timed out. Aborting");
                        Executor e = build.getExecutor();
                        if (e != null) {
                            e.interrupt();
                        }
                    }
                };
                Trigger.timer.schedule(this.task, (long)BuildTimeoutWrapper.this.timeoutMinutes * 60L * 1000L);
            }

            public boolean tearDown(Build build2, BuildListener listener2) throws IOException {
                this.task.cancel();
                return true;
            }
        }
        return new EnvironmentImpl();
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        DescriptorImpl() {
            super(BuildTimeoutWrapper.class);
        }

        public String getDisplayName() {
            return "Abort the build if it's stuck";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public BuildTimeoutWrapper newInstance(StaplerRequest req) throws Descriptor.FormException {
            BuildTimeoutWrapper w = new BuildTimeoutWrapper();
            req.bindParameters((Object)w, "build-timeout.");
            return w;
        }
    }
}

