/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.triggers.SafeTimerTask;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.TimerTask;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTimeoutWrapper
extends BuildWrapper {
    public int timeoutMinutes;
    public boolean failBuild;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public BuildTimeoutWrapper(int timeoutMinutes, boolean failBuild) {
        System.out.println("Constructor called: " + timeoutMinutes + " " + failBuild);
        this.timeoutMinutes = Math.max(3, timeoutMinutes);
        this.failBuild = failBuild;
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EnvironmentImpl
        extends BuildWrapper.Environment {
            private final 1EnvironmentImpl.TimeoutTimerTask task;

            public EnvironmentImpl() {
                super((BuildWrapper)BuildTimeoutWrapper.this);
                this.task = new 1EnvironmentImpl.TimeoutTimerTask(build, listener);
                Trigger.timer.schedule((TimerTask)((Object)this.task), (long)BuildTimeoutWrapper.this.timeoutMinutes * 60L * 1000L);
            }

            public boolean tearDown(AbstractBuild build2, BuildListener listener2) throws IOException, InterruptedException {
                this.task.cancel();
                return !this.task.timeout || !BuildTimeoutWrapper.this.failBuild;
            }

            final class 1EnvironmentImpl.TimeoutTimerTask
            extends SafeTimerTask {
                private final AbstractBuild build;
                private final BuildListener listener;
                public boolean timeout = false;

                private 1EnvironmentImpl.TimeoutTimerTask(AbstractBuild build, BuildListener listener) {
                    this.build = build;
                    this.listener = listener;
                }

                public void doRun() {
                    this.listener.getLogger().println("Build timed out. Aborting");
                    this.timeout = true;
                    Executor e = this.build.getExecutor();
                    if (e != null) {
                        e.interrupt();
                    }
                }
            }
        }
        return new EnvironmentImpl();
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        DescriptorImpl() {
            super(BuildTimeoutWrapper.class);
        }

        public String getDisplayName() {
            return "Abort the build if it's stuck";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

