/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.RootAction;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
@Extension
public class BulkBuilderAction
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(BulkBuilderAction.class.getName());

    public String getIconFileName() {
        return "/plugin/bulk-builder/icons/builder-32x32.png";
    }

    public String getDisplayName() {
        return "Bulk Builder";
    }

    public String getUrlName() {
        return "/bulkbuilder";
    }

    public void doBuildAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        LOGGER.log(Level.FINE, "doBuildAll action called");
        for (AbstractProject project : this.getProjects()) {
            LOGGER.log(Level.INFO, "Scheduling build for job: {0}", project.getDisplayName());
            project.scheduleBuild((Cause)new Cause.UserCause());
        }
        rsp.forwardToPreviousPage(req);
    }

    public void doBuildFailed(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        LOGGER.log(Level.FINE, "doBuildFailed action called");
        for (AbstractProject project : this.getProjects()) {
            Run build = project.getLastCompletedBuild();
            if (build != null && !build.getResult().isWorseOrEqualTo(Result.FAILURE)) continue;
            LOGGER.log(Level.INFO, "Scheduling build for job: {0}", project.getDisplayName());
            project.scheduleBuild((Cause)new Cause.UserCause());
        }
        rsp.forwardToPreviousPage(req);
    }

    private List<AbstractProject> getProjects() {
        ArrayList<AbstractProject> projects = new ArrayList<AbstractProject>();
        List topLevelItems = Hudson.getInstance().getItems();
        for (TopLevelItem topLevelItem : topLevelItems) {
            AbstractProject project;
            if (!(topLevelItem instanceof AbstractProject) || !(project = (AbstractProject)topLevelItem).isBuildable()) continue;
            projects.add(project);
        }
        return projects;
    }

    @Exported
    public int getQueueSize() {
        return Hudson.getInstance().getQueue().getItems().length;
    }
}

