/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.bulkbuilder.model;

import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder {
    private static final Logger LOGGER = Logger.getLogger(Builder.class.getName());

    public final void buildAll() {
        LOGGER.log(Level.FINE, "Starting to build all jobs.");
        for (AbstractProject project : this.getProjects()) {
            project.scheduleBuild((Cause)new Cause.UserCause());
        }
        LOGGER.log(Level.FINE, "Finished building all jobs.");
    }

    public final void buildFailed() {
        LOGGER.log(Level.FINE, "Starting to build failed jobs.");
        for (AbstractProject project : this.getProjects()) {
            Run build = project.getLastCompletedBuild();
            if (build != null && !build.getResult().isWorseOrEqualTo(Result.FAILURE)) continue;
            LOGGER.log(Level.FINE, "Scheduling build for job: {0}", project.getDisplayName());
            project.scheduleBuild((Cause)new Cause.UserCause());
        }
        LOGGER.log(Level.FINE, "Finished building failed jobs.");
    }

    public final void buildPattern(String pattern) {
        LOGGER.log(Level.FINE, "Starting to jobs matching pattern, '{0}'.", pattern);
        for (AbstractProject project : this.getProjects()) {
            if (!project.getDisplayName().contains(pattern)) continue;
            project.scheduleBuild((Cause)new Cause.UserCause());
        }
        LOGGER.log(Level.FINE, "Finished building jobs matching pattern.");
    }

    protected final List<AbstractProject> getProjects() {
        ArrayList<AbstractProject> projects = new ArrayList<AbstractProject>();
        for (TopLevelItem topLevelItem : Hudson.getInstance().getItems()) {
            AbstractProject project;
            if (!(topLevelItem instanceof AbstractProject) || !(project = (AbstractProject)topLevelItem).isBuildable()) continue;
            projects.add(project);
        }
        return projects;
    }
}

