/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.bulkbuilder;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.RootAction;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jvnet.hudson.plugins.bulkbuilder.Messages;
import org.jvnet.hudson.plugins.bulkbuilder.model.Builder;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
@Extension
public class BulkBuilderAction
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(BulkBuilderAction.class.getName());

    public final String getIconFileName() {
        return "/plugin/bulk-builder/icons/builder-32x32.png";
    }

    public final String getDisplayName() {
        return Messages.Plugin_Title();
    }

    public final String getUrlName() {
        return "/bulkbuilder";
    }

    public final void doBuild(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        LOGGER.log(Level.FINE, "doBuild action called");
        String build = req.getParameter("build");
        Builder builder = new Builder();
        if (build.equalsIgnoreCase("all")) {
            builder.buildAll();
        } else if (build.equalsIgnoreCase("failed")) {
            builder.buildFailed();
        } else if (build.equalsIgnoreCase("pattern")) {
            builder.buildPattern(req.getParameter("pattern"));
        }
        rsp.forwardToPreviousPage(req);
    }

    @Exported
    public final int getQueueSize() {
        return Hudson.getInstance().getQueue().getItems().length;
    }
}

