/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.bulkbuilder;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.RootAction;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jvnet.hudson.plugins.bulkbuilder.Messages;
import org.jvnet.hudson.plugins.bulkbuilder.model.BuildHistory;
import org.jvnet.hudson.plugins.bulkbuilder.model.BuildHistoryItem;
import org.jvnet.hudson.plugins.bulkbuilder.model.Builder;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
@Extension
public class BulkBuilderAction
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(BulkBuilderAction.class.getName());

    public final String getIconFileName() {
        return "/plugin/bulk-builder/icons/builder-32x32.png";
    }

    public final String getDisplayName() {
        return Messages.Plugin_Title();
    }

    public final String getUrlName() {
        return "/bulkbuilder";
    }

    public final void doBuild(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        LOGGER.log(Level.FINE, "doBuild action called");
        String build = req.getParameter("build");
        Builder builder = new Builder();
        if (build.equalsIgnoreCase("all")) {
            builder.buildAll();
        } else if (build.equalsIgnoreCase("failed")) {
            builder.buildFailed();
        } else if (build.equalsIgnoreCase("pattern")) {
            String pattern = req.getParameter("pattern");
            builder.buildPattern(pattern);
            BuildHistory history = (BuildHistory)Hudson.getInstance().getPlugin(BuildHistory.class);
            history.add(new BuildHistoryItem(pattern));
        }
        rsp.forwardToPreviousPage(req);
    }

    @Exported
    public final int getQueueSize() {
        return Hudson.getInstance().getQueue().getItems().length;
    }

    @Exported
    public final List<BuildHistoryItem> getHistory() {
        return ((BuildHistory)Hudson.getInstance().getPlugin(BuildHistory.class)).getAll();
    }
}

