/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cccc;

import com.thalesgroup.hudson.plugins.cccc.CcccReport;
import com.thalesgroup.hudson.plugins.cccc.model.ProjectSummary;

/*
 * Exception performing whole class analysis ignored.
 */
public class CcccSummary {
    private CcccSummary() {
    }

    public static String createReportSummary(CcccReport report, CcccReport previous) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href=\"ccccResult\">Cccc Results</a>");
        builder.append("\n");
        return builder.toString();
    }

    public static String createReportSummaryDetails(CcccReport report, CcccReport previousReport) {
        ProjectSummary previous = null;
        StringBuilder builder = new StringBuilder();
        ProjectSummary summary = report.getProjectSummary();
        if (summary == null) {
            return "";
        }
        if (previousReport != null) {
            previous = previousReport.projectSummary;
        }
        builder.append("<li>");
        builder.append("Number of modules :");
        builder.append(summary.getNbModules());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getNbModules(), (float)previous.getNbModules(), (StringBuilder)builder);
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("Lines of code :");
        builder.append(summary.getLinesOfCode());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getLinesOfCode(), (float)previous.getLinesOfCode(), (StringBuilder)builder);
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("McCabe's Cyclomatic Number :");
        builder.append(summary.getMcCabesCyclomaticComplexity());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getMcCabesCyclomaticComplexity(), (float)previous.getMcCabesCyclomaticComplexity(), (StringBuilder)builder);
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("Lines of Comment :");
        builder.append(summary.getLinesOfComment());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getLinesOfComment(), (float)previous.getLinesOfComment(), (StringBuilder)builder);
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("LOC/COM :");
        builder.append(summary.getLinesOfCode());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getLinesOfCode(), (float)previous.getLinesOfCode(), (StringBuilder)builder);
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("MVG/COM :");
        builder.append(summary.getMcCabesCyclomaticComplexityPerLineOfComment());
        if (previous != null) {
            builder.append("(not available)");
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("Information Flow measure ( inclusive ) :");
        builder.append(summary.getIF4());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getIF4(), (float)previous.getIF4(), (StringBuilder)builder);
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("Information Flow measure ( visible ) :");
        builder.append(summary.getIF4Visible());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getIF4Visible(), (float)previous.getIF4Visible(), (StringBuilder)builder);
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("Information Flow measure ( concrete ) :");
        builder.append(summary.getIF4Concrete());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getIF4Concrete(), (float)previous.getIF4Concrete(), (StringBuilder)builder);
        }
        builder.append("</li>");
        builder.append("<li>");
        builder.append("Lines of Code rejected by parser :");
        builder.append(summary.getRejectedLinesOfCode());
        if (previous != null) {
            CcccSummary.printDifference((float)summary.getRejectedLinesOfCode(), (float)previous.getRejectedLinesOfCode(), (StringBuilder)builder);
        }
        builder.append("</li>");
        return builder.toString();
    }

    private static void printDifference(float current, float previous, StringBuilder builder) {
        float difference = current - previous;
        builder.append(" (");
        if (difference >= 0.0f) {
            builder.append('+');
        }
        builder.append(difference);
        builder.append(")");
    }
}

