/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cccc;

import com.thalesgroup.hudson.plugins.cccc.CcccReport;
import com.thalesgroup.hudson.plugins.cccc.model.ObjectOrientedDesignModule;
import com.thalesgroup.hudson.plugins.cccc.model.OtherExtentsRejectedExtend;
import com.thalesgroup.hudson.plugins.cccc.model.ProceduralSummaryModule;
import com.thalesgroup.hudson.plugins.cccc.model.ProjectSummary;
import com.thalesgroup.hudson.plugins.cccc.model.StructuralSummaryModule;
import hudson.AbortException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CccccParser
implements FilePath.FileCallable<CcccReport> {
    private FilePath resultFilePath;
    private PrintStream logger;

    public CccccParser() {
        this.resultFilePath = null;
    }

    public CccccParser(FilePath resultFilePath, PrintStream logger) {
        this.logger = logger;
        this.resultFilePath = resultFilePath;
    }

    public CcccReport invoke(File workspace, VirtualChannel channel) throws IOException {
        Element otherExtentsElt;
        Element structuralSummaryElt;
        Element ooDesignElt;
        Element proceduralSummaryElt;
        CcccReport ccccReport = new CcccReport();
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build((Reader)new InputStreamReader((InputStream)new FileInputStream(new File(this.resultFilePath.toURI())), "UTF-8"));
        }
        catch (Exception e) {
            this.logger.println("Parsing file error :" + e.toString());
            throw new AbortException("Parsing file error");
        }
        Element root = document.getRootElement();
        Element projectSummaryElt = root.getChild("project_summary");
        if (projectSummaryElt != null) {
            this.logger.println("Process Project Summary element.");
            ProjectSummary projectSummary = this.fillSummaryProject(projectSummaryElt);
            ccccReport.setProjectSummary(projectSummary);
        }
        if ((proceduralSummaryElt = root.getChild("procedural_summary")) != null) {
            this.logger.println("Process Procedural Summary element.");
            List proceduralSummaryModuleList = this.fillProceduralSummary(proceduralSummaryElt);
            ccccReport.setProceduralSummaryModuleList(proceduralSummaryModuleList);
        }
        if ((ooDesignElt = root.getChild("oo_design")) != null) {
            this.logger.println("Process Object Oriented Design element.");
            List ooDesignEltList = this.fillObjectOrientedDesign(ooDesignElt);
            ccccReport.setObjectOrientedDesignModuleList(ooDesignEltList);
        }
        if ((structuralSummaryElt = root.getChild("structural_summary")) != null) {
            this.logger.println("Process Structural Summary element.");
            List structuralSummaryModuleList = this.fillStructuralSummary(structuralSummaryElt);
            ccccReport.setStructuralSummaryModuleList(structuralSummaryModuleList);
        }
        if ((otherExtentsElt = root.getChild("other_extents")) != null) {
            this.logger.println("Process Other Extents element.");
            List otherExtentsRejectedExtendList = this.fillOtherExtentsRejectedExtend(otherExtentsElt);
            ccccReport.setOtherExtentsRejectedExtendList(otherExtentsRejectedExtendList);
        }
        return ccccReport;
    }

    private String getValue(Element rootElement, String eletLine) {
        Element lineElement = rootElement.getChild(eletLine);
        return lineElement != null ? lineElement.getAttribute("value").getValue() : "";
    }

    private ProjectSummary fillSummaryProject(Element projectSummaryElt) {
        ProjectSummary projectSummary = new ProjectSummary();
        projectSummary.setNbModules(Integer.valueOf(this.getValue(projectSummaryElt, "number_of_modules")).intValue());
        projectSummary.setLinesOfCode(Integer.valueOf(this.getValue(projectSummaryElt, "lines_of_code")).intValue());
        projectSummary.setLinesOfCodePerModule(Float.valueOf(this.getValue(projectSummaryElt, "lines_of_code_per_module")).floatValue());
        projectSummary.setMcCabesCyclomaticComplexity(Integer.valueOf(this.getValue(projectSummaryElt, "McCabes_cyclomatic_complexity")).intValue());
        projectSummary.setMcCabesCyclomaticComplexityPerModule(Float.valueOf(this.getValue(projectSummaryElt, "McCabes_cyclomatic_complexity_per_module")).floatValue());
        projectSummary.setLinesOfComment(Integer.valueOf(this.getValue(projectSummaryElt, "lines_of_comment")).intValue());
        projectSummary.setLinesOfCommentPerModule(Float.valueOf(this.getValue(projectSummaryElt, "lines_of_comment_per_module")).floatValue());
        projectSummary.setLinesOfCodePerLineOfComment(this.getValue(projectSummaryElt, "lines_of_code_per_line_of_comment"));
        projectSummary.setMcCabesCyclomaticComplexityPerLineOfComment(this.getValue(projectSummaryElt, "McCabes_cyclomatic_complexity_per_line_of_comment"));
        projectSummary.setIF4(Integer.valueOf(this.getValue(projectSummaryElt, "IF4")).intValue());
        projectSummary.setIF4PerModule(Float.valueOf(this.getValue(projectSummaryElt, "IF4_per_module")).floatValue());
        projectSummary.setIF4Visible(Integer.valueOf(this.getValue(projectSummaryElt, "IF4_visible")).intValue());
        projectSummary.setIF4PerModule(Float.valueOf(this.getValue(projectSummaryElt, "IF4_visible_per_module")).floatValue());
        projectSummary.setRejectedLinesOfCode(Integer.valueOf(this.getValue(projectSummaryElt, "rejected_lines_of_code")).intValue());
        return projectSummary;
    }

    private List<ProceduralSummaryModule> fillProceduralSummary(Element proceduralSummaryElt) {
        ArrayList<ProceduralSummaryModule> proceduralSummaryModuleList = new ArrayList<ProceduralSummaryModule>();
        List modules = proceduralSummaryElt.getChildren("module");
        for (Element moduleElt : modules) {
            ProceduralSummaryModule proceduralSummaryModule = new ProceduralSummaryModule();
            proceduralSummaryModule.setName(moduleElt.getChildText("name"));
            proceduralSummaryModule.setLinesOfCode(Integer.valueOf(this.getValue(moduleElt, "lines_of_code")).intValue());
            proceduralSummaryModule.setMcCabesCyclomaticComplexity(Float.valueOf(this.getValue(moduleElt, "McCabes_cyclomatic_complexity")).floatValue());
            proceduralSummaryModule.setLinesOfComment(Integer.valueOf(this.getValue(moduleElt, "lines_of_comment")).intValue());
            proceduralSummaryModule.setLinesOfCodePerLineOfComment(this.getValue(moduleElt, "lines_of_code_per_line_of_comment"));
            proceduralSummaryModule.setMcCabesCyclomaticComplexityPerLineOfComment(this.getValue(moduleElt, "McCabes_cyclomatic_complexity_per_line_of_comment"));
            proceduralSummaryModuleList.add(proceduralSummaryModule);
        }
        return proceduralSummaryModuleList;
    }

    private List<ObjectOrientedDesignModule> fillObjectOrientedDesign(Element ooDesignElt) {
        ArrayList<ObjectOrientedDesignModule> objectOrientedDesignModuleList = new ArrayList<ObjectOrientedDesignModule>();
        List modules = ooDesignElt.getChildren("module");
        for (Element moduleElt : modules) {
            ObjectOrientedDesignModule objectOrientedDesignModule = new ObjectOrientedDesignModule();
            objectOrientedDesignModule.setName(moduleElt.getChildText("name"));
            objectOrientedDesignModule.setWeightedMethodsPerClassUnity((float)Integer.valueOf(this.getValue(moduleElt, "weighted_methods_per_class_unity")).intValue());
            objectOrientedDesignModule.setWeightedMethodsPerClassVisibility((float)Integer.valueOf(this.getValue(moduleElt, "weighted_methods_per_class_visibility")).intValue());
            objectOrientedDesignModule.setDepthOfInheritanceTree((float)Integer.valueOf(this.getValue(moduleElt, "depth_of_inheritance_tree")).intValue());
            objectOrientedDesignModule.setNumberOfChildren((float)Integer.valueOf(this.getValue(moduleElt, "number_of_children")).intValue());
            objectOrientedDesignModule.setCouplingBetweenObjects((float)Integer.valueOf(this.getValue(moduleElt, "coupling_between_objects")).intValue());
            objectOrientedDesignModuleList.add(objectOrientedDesignModule);
        }
        return objectOrientedDesignModuleList;
    }

    private List<StructuralSummaryModule> fillStructuralSummary(Element structuralSummaryElt) {
        ArrayList<StructuralSummaryModule> structuralSummaryModuleList = new ArrayList<StructuralSummaryModule>();
        List modules = structuralSummaryElt.getChildren("module");
        for (Element moduleElt : modules) {
            StructuralSummaryModule structuralSummaryModule = new StructuralSummaryModule();
            structuralSummaryModule.setName(moduleElt.getChildText("name"));
            structuralSummaryModule.setFanOutVisible(Float.valueOf(this.getValue(moduleElt, "fan_out_visible")).floatValue());
            structuralSummaryModule.setFanOutConcrete(Float.valueOf(this.getValue(moduleElt, "fan_out_concrete")).floatValue());
            structuralSummaryModule.setFanOut(Float.valueOf(this.getValue(moduleElt, "fan_out")).floatValue());
            structuralSummaryModule.setFanInVisible(Float.valueOf(this.getValue(moduleElt, "fan_in_visible")).floatValue());
            structuralSummaryModule.setFanInConcrete(Float.valueOf(this.getValue(moduleElt, "fan_in_concrete")).floatValue());
            structuralSummaryModule.setFanIin(Float.valueOf(this.getValue(moduleElt, "fan_in")).floatValue());
            structuralSummaryModule.setIF4Visible(Float.valueOf(this.getValue(moduleElt, "IF4_visible")).floatValue());
            structuralSummaryModule.setIF4Concrete(Float.valueOf(this.getValue(moduleElt, "IF4_concrete")).floatValue());
            structuralSummaryModule.setIF4(Float.valueOf(this.getValue(moduleElt, "IF4")).floatValue());
            structuralSummaryModuleList.add(structuralSummaryModule);
        }
        return structuralSummaryModuleList;
    }

    private List<OtherExtentsRejectedExtend> fillOtherExtentsRejectedExtend(Element otherExtentsRejectedExtendElt) {
        ArrayList<OtherExtentsRejectedExtend> otherExtentsRejectedExtendList = new ArrayList<OtherExtentsRejectedExtend>();
        List rejectedExtentList = otherExtentsRejectedExtendElt.getChildren("rejected_extent");
        for (Element rejectedExtentElt : rejectedExtentList) {
            OtherExtentsRejectedExtend otherExtendsRejectedExtend = new OtherExtentsRejectedExtend();
            otherExtendsRejectedExtend.setName(rejectedExtentElt.getChildText("name"));
            Element sourceReferenceElt = rejectedExtentElt.getChild("source_reference");
            otherExtendsRejectedExtend.setSourceReference(sourceReferenceElt.getAttribute("file").getValue());
            otherExtendsRejectedExtend.setSourceReferenceLine(Integer.valueOf(sourceReferenceElt.getAttribute("line").getValue()).intValue());
            otherExtendsRejectedExtend.setLinesOfCode(Integer.valueOf(this.getValue(rejectedExtentElt, "lines_of_code")).intValue());
            otherExtendsRejectedExtend.setLinesOfComment(Integer.valueOf(this.getValue(rejectedExtentElt, "lines_of_comment")).intValue());
            otherExtendsRejectedExtend.setMcCabesCyclomaticComplexity(this.getValue(rejectedExtentElt, "McCabes_cyclomatic_complexity"));
            otherExtentsRejectedExtendList.add(otherExtendsRejectedExtend);
        }
        return otherExtentsRejectedExtendList;
    }

    public FilePath getResultFilePath() {
        return this.resultFilePath;
    }

    public void setResultFilePath(FilePath resultFilePath) {
        this.resultFilePath = resultFilePath;
    }

    public PrintStream getLogger() {
        return this.logger;
    }

    public void setLogger(PrintStream logger) {
        this.logger = logger;
    }
}

