/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cccc;

import com.thalesgroup.hudson.plugins.cccc.CcccReport;
import com.thalesgroup.hudson.plugins.cccc.CcccResult;
import com.thalesgroup.hudson.plugins.cccc.CcccSummary;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.Serializable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CcccBuildAction
implements Action,
Serializable,
StaplerProxy {
    public static final String URL_NAME = "ccccResult";
    private AbstractBuild<?, ?> build;
    private CcccResult result;

    public CcccBuildAction(AbstractBuild<?, ?> build, CcccResult result) {
        this.build = build;
        this.result = result;
    }

    public String getIconFileName() {
        return "/plugin/cccc/icons/cccc-24.png";
    }

    public String getDisplayName() {
        return "CCCC Results";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getSummary() {
        return CcccSummary.createReportSummary(this.result.getReport(), this.getPreviousReport());
    }

    public String getDetails() {
        return CcccSummary.createReportSummaryDetails(this.result.getReport(), this.getPreviousReport());
    }

    public CcccResult getResult() {
        return this.result;
    }

    private CcccReport getPreviousReport() {
        CcccResult previous = this.getPreviousResult();
        if (previous == null) {
            return null;
        }
        return previous.getReport();
    }

    CcccResult getPreviousResult() {
        CcccBuildAction previousAction = this.getPreviousAction();
        CcccResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    CcccBuildAction getPreviousAction() {
        AbstractBuild previousBuild = (AbstractBuild)this.build.getPreviousBuild();
        if (previousBuild != null) {
            return (CcccBuildAction)previousBuild.getAction(CcccBuildAction.class);
        }
        return null;
    }

    AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Object getTarget() {
        return this.result;
    }
}

