/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cccc;

import com.thalesgroup.hudson.plugins.cccc.CcccBuildAction;
import com.thalesgroup.hudson.plugins.cccc.CcccChartBuilder;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CcccProjectAction
implements Action,
Serializable {
    public static final String URL_NAME = "ccccResult";
    public static final int CHART_WIDTH = 500;
    public static final int CHART_HEIGHT = 200;
    public AbstractProject<?, ?> project;

    public CcccProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return "/plugin/cccc/icons/cccc-24.png";
    }

    public String getDisplayName() {
        return "Cccc Results";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), URL_NAME));
        }
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(CcccBuildAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public final boolean hasValidResults() {
        CcccBuildAction resultAction;
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null && (resultAction = (CcccBuildAction)build.getAction(CcccBuildAction.class)) != null) {
            return resultAction.getPreviousResult() != null;
        }
        return false;
    }

    public void doGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        CcccBuildAction lastAction = (CcccBuildAction)lastBuild.getAction(CcccBuildAction.class);
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar timestamp = lastBuild.getTimestamp();
        if (request.checkIfModified(timestamp, response)) {
            return;
        }
        new CcccChartBuilder(lastAction, 500, 200).doPng(request, response);
    }
}

