/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cccc;

import com.thalesgroup.hudson.plugins.cccc.CcccBuildAction;
import com.thalesgroup.hudson.plugins.cccc.CcccProjectAction;
import com.thalesgroup.hudson.plugins.cccc.CcccReport;
import com.thalesgroup.hudson.plugins.cccc.CcccResult;
import com.thalesgroup.hudson.plugins.cccc.CccccParser;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CcccPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String metricFilePath;

    @DataBoundConstructor
    public CcccPublisher(String metricFilePath) {
        this.metricFilePath = metricFilePath;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CcccProjectAction(project);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.canContinue(build.getResult())) {
            CcccReport report;
            listener.getLogger().println("Parsing cccc results");
            FilePath workspace = build.getWorkspace();
            PrintStream logger = listener.getLogger();
            CccccParser parser = new CccccParser(new FilePath(build.getWorkspace(), this.metricFilePath));
            try {
                report = (CcccReport)workspace.act((FilePath.FileCallable)parser);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return false;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return false;
            }
            CcccResult result = new CcccResult(report, build);
            CcccBuildAction buildAction = new CcccBuildAction(build, result);
            build.addAction((Action)buildAction);
            listener.getLogger().println("End Processing cccc results");
        }
        build.setResult(Result.SUCCESS);
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getMetricFilePath() {
        return this.metricFilePath;
    }
}

