/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.ccm.CCMBuilderDescription;
import hudson.plugins.ccm.CCMBuilderInstallation;
import hudson.plugins.ccm.config.CCMConfigCallable;
import hudson.plugins.ccm.config.CCMResultCallable;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMBuilder
extends Builder
implements Serializable {
    private final String ccmName;
    private final String srcFolder;
    private final Boolean recursive;
    private final Boolean outputXml;
    private final String numMetrics;
    @Extension
    public static final CCMBuilderDescription DESCRIPTOR = new CCMBuilderDescription();
    public static final String CCM_CONFIG_FILE = "ccm.config.xml";
    public static final String CCM_RESULT_FILE = "ccm.result.xml";
    public static final Integer DEFAULT_NUMBER_OF_METRICS = 30;

    @DataBoundConstructor
    public CCMBuilder(String ccmName, String srcFolder, Boolean recursive, Boolean outputXml, String numMetrics) {
        this.ccmName = ccmName;
        this.srcFolder = srcFolder;
        this.recursive = recursive;
        this.outputXml = outputXml;
        this.numMetrics = numMetrics == null || numMetrics.length() <= 0 ? DEFAULT_NUMBER_OF_METRICS.toString() : numMetrics;
    }

    public String getCcmName() {
        return this.ccmName;
    }

    public String getSrcFolder() {
        return this.srcFolder;
    }

    public Boolean isRecursive() {
        return this.recursive;
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public Boolean isOutputXml() {
        return this.outputXml;
    }

    public String getNumMetrics() {
        return this.numMetrics;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public CCMBuilderInstallation getCCM() {
        CCMBuilderInstallation foundInstallation = null;
        for (CCMBuilderInstallation installation : DESCRIPTOR.getInstallations()) {
            if (this.getCcmName() == null || !installation.getName().equals(this.getCcmName())) continue;
            foundInstallation = installation;
        }
        return foundInstallation;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        CCMBuilderInstallation installation = this.getCCM();
        if (installation == null) {
            listener.error("Missing CCM installation");
            build.setResult(Result.FAILURE);
            return false;
        }
        String pathToCCM = installation.getExecutable(launcher);
        listener.getLogger().println("Path To CCM.exe: " + pathToCCM);
        args.add("\"");
        args.add(pathToCCM);
        FilePath workspace = build.getWorkspace();
        args.addKeyValuePairs("-P:", build.getBuildVariables());
        CCMConfigCallable ccmConfigGenerator = new CCMConfigCallable(this.srcFolder, this.recursive, this.numMetrics, listener);
        String ccmConfigFile = (String)workspace.act((FilePath.FileCallable)ccmConfigGenerator);
        args.add(ccmConfigFile);
        args.add(">");
        CCMResultCallable ccmResultCallable = new CCMResultCallable();
        String ccmResultFile = (String)workspace.act((FilePath.FileCallable)ccmResultCallable);
        args.add(ccmResultFile);
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        args.add("\"");
        listener.getLogger().println("Executing CCM command: " + args.toStringWithQuote());
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            return r == 0;
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("CCM command execution failed"));
            build.setResult(Result.FAILURE);
            return false;
        }
    }
}

