/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm.config;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMConfigCallable
implements FilePath.FileCallable<String> {
    private final String srcFolder;
    private final Boolean isRecursive;
    private final String numMetrics;
    private final BuildListener listener;

    public CCMConfigCallable(String srcFolder, Boolean isRecursive, String numMetrics, BuildListener listener) {
        this.srcFolder = srcFolder;
        this.isRecursive = isRecursive;
        this.numMetrics = numMetrics;
        this.listener = listener;
    }

    private String createCCMConfigFile(File workspace) throws IOException {
        File ccmConfigFile = new File(workspace, "ccm.config.xml");
        this.listener.getLogger().println("Creating CCM config file " + ccmConfigFile.getAbsolutePath());
        ccmConfigFile.createNewFile();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<ccm>\n");
        buffer.append("<exclude></exclude>\n");
        buffer.append("<analyze>\n");
        buffer.append("<folder>" + new File(workspace, this.srcFolder).getAbsolutePath() + "</folder>\n");
        buffer.append("</analyze>\n");
        buffer.append("<recursive>" + (this.isRecursive == true ? "yes" : "no") + "</recursive>\n");
        buffer.append("<outputXML>yes</outputXML>\n");
        buffer.append("<numMetrics>" + this.numMetrics + "</numMetrics>\n");
        buffer.append("</ccm>\n");
        this.listener.getLogger().println("Writing CCM configuration into file");
        this.listener.getLogger().println(buffer.toString());
        FileWriter writer = new FileWriter(ccmConfigFile);
        writer.append(buffer.toString());
        writer.flush();
        writer.close();
        return ccmConfigFile.getAbsolutePath();
    }

    public String invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        return this.createCCMConfigFile(workspace);
    }
}

