/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.ccm.CCMResult;
import hudson.plugins.ccm.ReportSummary;
import hudson.plugins.ccm.model.CCMReport;
import java.io.Serializable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMBuildAction
implements Action,
Serializable,
StaplerProxy {
    public static final String DISPLAY_NAME = "CCM";
    public static final String ICON_FILE_NAME = "/plugin/ccm/icons/ccm-24.png";
    public static final String URL_NAME = "ccmResult";
    private AbstractBuild<?, ?> build;
    private CCMResult result;

    public CCMBuildAction(AbstractBuild<?, ?> build, CCMResult result) {
        this.build = build;
        this.result = result;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getIconFileName() {
        return ICON_FILE_NAME;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public Object getTarget() {
        return this.result;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public CCMResult getResult() {
        return this.result;
    }

    private CCMReport getPreviousReport() {
        CCMResult previousResult = this.getPreviousResult();
        CCMReport previousReport = null;
        if (previousResult != null) {
            previousReport = previousResult.getReport();
        }
        return previousReport;
    }

    public CCMResult getPreviousResult() {
        CCMBuildAction previousAction = this.getPreviousAction();
        CCMResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    public CCMBuildAction getPreviousAction() {
        AbstractBuild previousBuild;
        if (this.build != null && (previousBuild = (AbstractBuild)this.build.getPreviousBuild()) != null) {
            return (CCMBuildAction)previousBuild.getAction(CCMBuildAction.class);
        }
        return null;
    }

    public String getSummary() {
        return ReportSummary.createReportSummary(this.result.getReport(), this.getPreviousReport());
    }

    public String getDetails() {
        return ReportSummary.createReportSummaryDetails(this.result.getReport(), this.getPreviousReport());
    }
}

