/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

public class CCMBuilderInstallation
implements Serializable {
    private String name;
    private String pathToCCM;

    @DataBoundConstructor
    public CCMBuilderInstallation(String name, String pathToCCM) {
        this.name = name;
        this.pathToCCM = pathToCCM;
    }

    public String getName() {
        return this.name;
    }

    public String getPathToCCM() {
        return this.pathToCCM;
    }

    public String getExecutable(Launcher launcher) throws InterruptedException, IOException {
        VirtualChannel channel = launcher.getChannel();
        String executable = (String)channel.call((Callable)new Callable<String, IOException>(){

            public String call() throws IOException {
                File exe = CCMBuilderInstallation.this.getExecutableFile();
                if (exe.exists()) {
                    return exe.getPath();
                }
                throw new IOException(exe.getPath() + " doesn't exist");
            }
        });
        return executable;
    }

    public File getExecutableFile() {
        return new File(this.pathToCCM);
    }

    public boolean getExists() throws InterruptedException, IOException {
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(TaskListener.NULL);
        VirtualChannel channel = launcher.getChannel();
        Boolean result = (Boolean)channel.call((Callable)new Callable<Boolean, IOException>(){

            public Boolean call() throws IOException {
                return CCMBuilderInstallation.this.getExecutableFile().exists();
            }
        });
        return result;
    }
}

