/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.plugins.ccm.CCMAreaRenderer;
import hudson.plugins.ccm.CCMBuildAction;
import hudson.plugins.ccm.CCMResult;
import hudson.plugins.ccm.model.CCMReport;
import hudson.plugins.ccm.model.Metric;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class CCMChartBuilder
implements Serializable {
    public static JFreeChart buildChart(CCMBuildAction action) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"lines", (CategoryDataset)CCMChartBuilder.buildDataset(action), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        CCMAreaRenderer renderer = new CCMAreaRenderer(action.getUrlName());
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chart;
    }

    private static CategoryDataset buildDataset(CCMBuildAction lastAction) {
        DataSetBuilder builder = new DataSetBuilder();
        CCMBuildAction action = lastAction;
        do {
            CCMResult result;
            if ((result = action.getResult()) == null) continue;
            CCMReport report = result.getReport();
            ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(action.getBuild());
            for (Metric m : report.getMetrics()) {
                builder.add((Number)m.getComplexity(), (Comparable)((Object)m.getUnit()), (Comparable)buildLabel);
            }
        } while ((action = action.getPreviousAction()) != null);
        return builder.build();
    }
}

