/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.plugins.ccm.CCMBuildAction;
import hudson.plugins.ccm.CCMResult;
import hudson.plugins.ccm.model.CCMReport;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.Calendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMTrendGraph
extends Graph {
    private CCMBuildAction lastAction;

    public CCMTrendGraph(CCMBuildAction lastAction, Calendar timestamp, int defaultW, int defaultH) {
        super(timestamp, defaultW, defaultH);
        this.lastAction = lastAction;
    }

    protected DataSetBuilder<String, String> createDataSet() {
        DataSetBuilder data = new DataSetBuilder();
        CCMBuildAction tempAction = this.lastAction;
        do {
            CCMResult result = tempAction.getResult();
            CCMReport report = result.getReport();
            data.add((Number)Float.valueOf(report.getAverageComplexityPerMethod()), (Comparable)((Object)"0Average"), (Comparable)((Object)"Label?"));
            data.add((Number)report.getNumberOfMethods(), (Comparable)((Object)"1Number"), (Comparable)((Object)"Label2?"));
            data.add((Number)report.getTotalComplexity(), (Comparable)((Object)"2Total"), (Comparable)((Object)"Label3?"));
        } while ((tempAction = tempAction.getPreviousAction()) != null);
        return data;
    }

    protected JFreeChart createGraph() {
        CategoryDataset dataset = this.createDataSet().build();
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"MyLabel", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        ChartUtil.adjustChebyshev((CategoryDataset)dataset, (NumberAxis)rangeAxis);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRange(true);
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

            public Paint getItemPaint(int row, int column) {
                return super.getItemPaint(row, column);
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                return "Tooltip";
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
        ar.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

