/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm.util;

import hudson.plugins.ccm.CCMBuildAction;
import hudson.plugins.ccm.CCMResult;
import hudson.plugins.ccm.model.CCMReport;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class ChartUtil {
    public static JFreeChart buildXYChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Build #", null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(1, true);
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    public static final XYDataset createXYDataset(CCMBuildAction lastAction) {
        CCMBuildAction tempAction = lastAction;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries avgCCseries = new XYSeries((Comparable)((Object)"Average Complexity"));
        XYSeries totalCCseries = new XYSeries((Comparable)((Object)"Total Complexity"));
        XYSeries numberOfMethodsSeries = new XYSeries((Comparable)((Object)"Number of Methods"));
        dataset.addSeries(avgCCseries);
        dataset.addSeries(totalCCseries);
        dataset.addSeries(numberOfMethodsSeries);
        do {
            CCMResult result = tempAction.getResult();
            CCMReport report = result.getReport();
            int buildNumber = tempAction.getBuild().number;
            avgCCseries.add((double)buildNumber, (double)report.getAverageComplexityPerMethod());
            totalCCseries.add((double)buildNumber, (double)report.getTotalComplexity());
            numberOfMethodsSeries.add((double)buildNumber, (double)report.getNumberOfMethods());
        } while ((tempAction = tempAction.getPreviousAction()) != null);
        return dataset;
    }
}

