/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.ccm.CCMBuilderDescription;
import hudson.plugins.ccm.CCMBuilderInstallation;
import hudson.plugins.ccm.util.CCMUtil;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMBuilder
extends Builder {
    private final String ccmName;
    private final String srcFolder;
    private final Boolean recursive;
    private final Boolean outputXml;
    private final String numMetrics;
    @Extension
    public static final CCMBuilderDescription DESCRIPTOR = new CCMBuilderDescription();

    @DataBoundConstructor
    public CCMBuilder(String ccmName, String srcFolder, Boolean recursive, Boolean outputXml, String numMetrics) {
        this.ccmName = ccmName;
        this.srcFolder = srcFolder;
        this.recursive = recursive;
        this.outputXml = outputXml;
        this.numMetrics = numMetrics == null || numMetrics.length() <= 0 ? "30" : numMetrics;
    }

    public String getCcmName() {
        return this.ccmName;
    }

    public String getSrcFolder() {
        return this.srcFolder;
    }

    public Boolean isRecursive() {
        return this.recursive;
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public Boolean isOutputXml() {
        return this.outputXml;
    }

    public String getNumMetrics() {
        return this.numMetrics;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public CCMBuilderInstallation getCCM() {
        CCMBuilderInstallation foundInstallation = null;
        for (CCMBuilderInstallation installation : DESCRIPTOR.getInstallations()) {
            if (this.getCcmName() == null || !installation.getName().equals(this.getCcmName())) continue;
            foundInstallation = installation;
        }
        return foundInstallation;
    }

    private void createXMLConfig(FilePath workspace, BuildListener listener) throws IOException {
        File ccmConfigFile = new File(workspace.getRemote(), "ccm.config.xml");
        listener.getLogger().println("Creating CCM config file " + ccmConfigFile.getAbsolutePath());
        ccmConfigFile.createNewFile();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<ccm>\n");
        buffer.append("<exclude></exclude>\n");
        buffer.append("<analyze>\n");
        buffer.append("<folder>" + CCMUtil.getSrcFolderRelativeToWorkspace(this.getSrcFolder(), workspace) + "</folder>\n");
        buffer.append("</analyze>\n");
        buffer.append("<recursive>" + CCMUtil.yesOrNo(this.isRecursive()) + "</recursive>\n");
        buffer.append("<outputXML>yes</outputXML>\n");
        buffer.append("<numMetrics>" + this.getNumMetrics() + "</numMetrics>\n");
        buffer.append("</ccm>\n");
        listener.getLogger().println("Writing CCM configuration into file");
        listener.getLogger().println(buffer.toString());
        FileWriter writer = new FileWriter(ccmConfigFile);
        writer.append(buffer.toString());
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixResultFile(File file, PrintStream logger) {
        BufferedReader reader = null;
        StringBuffer newFile = new StringBuffer();
        logger.println("Removing CCM header line...");
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            boolean found = false;
            while ((line = reader.readLine()) != null) {
                if (!found && line.contains("Loading configuration from")) {
                    found = true;
                    continue;
                }
                newFile.append(line);
                newFile.append("\n");
            }
        }
        catch (IOException e) {
            logger.println("Error removing header from CCM result file [" + file + "]: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(newFile.toString().trim());
        }
        catch (IOException e) {
            logger.println("Error fix CCM result file: " + e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        CCMBuilderInstallation installation = this.getCCM();
        String execName = installation.getPathToCCM();
        if (installation == null) {
            listener.fatalError("Invalid CCM installation");
            return false;
        }
        File exec = installation.getExecutable();
        if (!installation.getExists()) {
            listener.fatalError(exec + " doesn't exist");
            return false;
        }
        listener.getLogger().println("Path To CCM.exe: " + execName);
        args.add(execName);
        FilePath workspace = build.getWorkspace();
        try {
            this.createXMLConfig(workspace, listener);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Error creating CCM config file"));
            return false;
        }
        args.add(new File(workspace.getRemote(), "ccm.config.xml"));
        if (launcher.isUnix()) {
            listener.fatalError("CCM can be run only in Win platforms.");
            return false;
        }
        args.prepend(new String[]{"cmd.exe", "/C"});
        args.add(new String[]{">", "ccm.result.xml"});
        args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        listener.getLogger().println("Executing command: " + args.toStringWithQuote());
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            this.fixResultFile(new File(workspace.getRemote(), "ccm.result.xml"), listener.getLogger());
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }
}

