/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.plugins.ccm.model.CCMReport;
import hudson.plugins.ccm.model.Metric;

public class ReportSummary {
    public static String createReportSummary(CCMReport report, CCMReport previous) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href=\"ccmResult\">");
        builder.append(report.getAverageComplexityPerMethod());
        if (previous != null) {
            ReportSummary.printDifference(report.getAverageComplexityPerMethod(), previous.getAverageComplexityPerMethod(), builder);
        }
        builder.append(" average complexity per method.</a> in ");
        builder.append(report.getNumberOfMethods());
        if (previous != null) {
            ReportSummary.printDifference(report.getNumberOfMethods(), previous.getNumberOfMethods(), builder);
        }
        builder.append(" methods. Project's total Cyclomatic Complexity: ");
        builder.append(report.getTotalComplexity());
        if (previous != null) {
            ReportSummary.printDifference(report.getTotalComplexity(), previous.getTotalComplexity(), builder);
        }
        builder.append(".");
        return builder.toString();
    }

    public static String createReportSummaryDetails(CCMReport report, CCMReport previous) {
        StringBuilder builder = new StringBuilder();
        builder.append("Top 15 CC methods.");
        builder.append("<table border=\"1\">\n");
        int i = 0;
        for (Metric metric : report.getMetrics()) {
            builder.append("<tr>\n");
            builder.append("<td>" + metric.getFile() + "</td>");
            builder.append("<td>" + metric.getUnit() + "</td>");
            builder.append("<td>" + metric.getClassification() + "</td>");
            builder.append("<td>" + metric.getComplexity() + "</td>\n");
            builder.append("</tr>\n");
            if (++i != 15) continue;
            break;
        }
        builder.append("</table>");
        return builder.toString();
    }

    private static void printDifference(float current, float previous, StringBuilder builder) {
        float difference = current - previous;
        builder.append(" (");
        if ((double)difference >= 0.0) {
            builder.append('+');
        }
        builder.append(difference);
        builder.append(")");
    }
}

