/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.plugins.ccm.CCMBuildAction;
import hudson.plugins.ccm.util.ChartUtil;
import java.io.IOException;
import java.io.Serializable;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMProjectAction
extends Actionable
implements ProminentProjectAction,
Serializable {
    public static final String ICON_FILE_NAME = "/plugin/ccm/icons/ccm-24.png";
    public static final String URL_NAME = "ccmResult";
    public static final int CHART_WIDTH = 500;
    public static final int CHART_HEIGHT = 200;
    private AbstractProject<?, ?> project;

    public CCMProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "CCM Results";
    }

    public String getIconFileName() {
        return ICON_FILE_NAME;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), URL_NAME));
        }
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(CCMBuildAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public final boolean hasValidResults() {
        CCMBuildAction resultAction;
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null && (resultAction = (CCMBuildAction)build.getAction(CCMBuildAction.class)) != null) {
            return resultAction.getPreviousResult() != null;
        }
        return false;
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        CCMBuildAction lastAction = (CCMBuildAction)lastBuild.getAction(CCMBuildAction.class);
        XYDataset dataset = ChartUtil.createXYDataset((CCMBuildAction)lastAction);
        JFreeChart chart = ChartUtil.buildXYChart((XYDataset)dataset);
        new /* Unavailable Anonymous Inner Class!! */.doMap(request, response);
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        CCMBuildAction lastAction = (CCMBuildAction)lastBuild.getAction(CCMBuildAction.class);
        XYDataset dataset = ChartUtil.createXYDataset((CCMBuildAction)lastAction);
        JFreeChart chart = ChartUtil.buildXYChart((XYDataset)dataset);
        new /* Unavailable Anonymous Inner Class!! */.doPng(request, response);
    }

    public String getSearchUrl() {
        return URL_NAME;
    }
}

