/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.ccm.CCMBuildAction;
import hudson.plugins.ccm.CCMProjectAction;
import hudson.plugins.ccm.CCMPublisherDescriptor;
import hudson.plugins.ccm.CCMResult;
import hudson.plugins.ccm.model.CCMParser;
import hudson.plugins.ccm.model.CCMReport;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMPublisher
extends Recorder
implements Serializable {
    @Extension
    public static final CCMPublisherDescriptor DESCRIPTOR = new CCMPublisherDescriptor();

    @DataBoundConstructor
    public CCMPublisher() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CCMProjectAction(project);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Performing CCM publisher...");
        if (this.canContinue(build.getResult())) {
            CCMReport report;
            FilePath workspace = build.getWorkspace();
            PrintStream logger = listener.getLogger();
            CCMParser parser = new CCMParser(logger);
            listener.getLogger().println("Generating report...");
            try {
                report = (CCMReport)workspace.act((FilePath.FileCallable)parser);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(logger);
                return false;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(logger);
                return false;
            }
            CCMResult result = new CCMResult(report, build);
            CCMBuildAction buildAction = new CCMBuildAction(build, result);
            build.addAction((Action)buildAction);
        } else {
            listener.getLogger().println("Canceling CCM publisher. Wrong project status.");
        }
        return true;
    }
}

