/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm.model;

import hudson.FilePath;
import hudson.plugins.ccm.model.CCM;
import hudson.plugins.ccm.model.CCMReport;
import hudson.plugins.ccm.model.CCMXmlHandler;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.framework.io.IOException2;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMParser
implements FilePath.FileCallable<CCMReport> {
    private static final String RESULT_FILE_NAME = "ccm.result.xml";
    private boolean LOG_ENABLED = false;
    private transient PrintStream logger;

    public CCMParser(PrintStream logger) {
        this.logger = logger;
    }

    public CCMReport invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        CCMReport report = new CCMReport();
        this.parse(workspace, RESULT_FILE_NAME, report);
        return report;
    }

    private void parse(File workspace, String fileName, CCMReport report) throws IOException {
        File file = new File(workspace, fileName);
        FileInputStream in = new FileInputStream(file);
        this.parse((InputStream)in, report);
        ((InputStream)in).close();
    }

    private void parse(InputStream in, CCMReport report) throws IOException {
        if (this.LOG_ENABLED && this.logger != null) {
            this.logger.println("Parsing ccm.result.xml file...");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {
            // empty catch block
        }
        try {
            SAXParser parser = factory.newSAXParser();
            CCMXmlHandler handler = new CCMXmlHandler();
            parser.parse(in, (DefaultHandler)handler);
            CCM ccm = handler.getCCM();
            List metrics = ccm.getMetrics();
            report.setMetrics(metrics);
            report.updateNumbers();
        }
        catch (ParserConfigurationException e) {
            throw new IOException2("Cannot parse ccm results", (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Cannot parse ccm results", (Throwable)e);
        }
    }
}

