/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ccm.model;

import hudson.plugins.ccm.model.Metric;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCMReport
implements Serializable {
    private int numberOfMethods;
    private float averageComplexityPerMethod;
    private int totalComplexity;
    private List<Metric> metrics = new ArrayList<Metric>();

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void updateNumbers() {
        this.numberOfMethods = this.metrics.size();
        int sum = 0;
        for (Metric metric : this.metrics) {
            sum += metric.getComplexity();
        }
        this.totalComplexity = sum;
        if (sum > 0) {
            this.averageComplexityPerMethod = (float)sum / (float)this.numberOfMethods;
        }
    }

    public int getNumberOfMethods() {
        return this.numberOfMethods;
    }

    public float getAverageComplexityPerMethod() {
        return this.averageComplexityPerMethod;
    }

    public int getTotalComplexity() {
        return this.totalComplexity;
    }

    public String toString() {
        return "CCMReport [averageComplexityPerMethod=" + this.averageComplexityPerMethod + ", numberOfMethods=" + this.numberOfMethods + ", totalComplexity=" + this.totalComplexity + "]";
    }
}

