/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.changelog_history;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.changelog_history.Messages;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.SubversionChangeLogSet;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogHistoryAction
implements Action {
    private final AbstractBuild<?, ?> build;

    public ChangeLogHistoryAction(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getUrlName() {
        return "changelog-history";
    }

    public String getDisplayName() {
        return Messages.actionTitle();
    }

    public String getIconFileName() {
        return "notepad.gif";
    }

    public Map<Long, ChangeLogSet> getChangeLogSets() throws Exception {
        ChangeLogParser parser = this.build.getProject().getScm().createChangeLogParser();
        File baseDir = new File(this.build.getRootDir(), "changelog-history");
        File[] files = baseDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().matches("\\d+\\.xml");
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.signum(ChangeLogHistoryAction.getBuildNumber(f2) - ChangeLogHistoryAction.getBuildNumber(f1));
            }
        });
        LinkedHashMap<Long, ChangeLogSet> result = new LinkedHashMap<Long, ChangeLogSet>(files.length * 2);
        for (File file : files) {
            ChangeLogSet changeLogSet = parser.parse(this.build, file);
            if (changeLogSet instanceof SubversionChangeLogSet) {
                try {
                    Field f = SubversionChangeLogSet.class.getDeclaredField("revisionMap");
                    f.setAccessible(true);
                    f.set(changeLogSet, new HashMap(0));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            result.put(ChangeLogHistoryAction.getBuildNumber(file), changeLogSet);
        }
        return result;
    }

    private static long getBuildNumber(File file) {
        String fn = file.getName();
        return Long.parseLong(fn.substring(0, fn.indexOf(46)));
    }

    public Object getDynamic(String oldBuild, StaplerRequest req, StaplerResponse rsp) throws Exception {
        File f = new File(new File(this.build.getRootDir(), "changelog-history"), oldBuild + ".xml");
        if (!f.isFile()) {
            return null;
        }
        ChangeLogParser parser = this.build.getProject().getScm().createChangeLogParser();
        req.setAttribute("changeSet", (Object)parser.parse(this.build, f));
        req.setAttribute("buildNumber", (Object)oldBuild);
        return this;
    }
}

