/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.changelog_history;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.listeners.RunListener;
import hudson.plugins.changelog_history.ChangeLogHistoryAction;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogHistoryRunListener
extends RunListener<AbstractBuild> {
    public ChangeLogHistoryRunListener() {
        super(AbstractBuild.class);
    }

    public void onDeleted(AbstractBuild build) {
        try {
            this.copyChangeLogs(build);
        }
        catch (Exception ex) {
            Logger.getLogger(ChangeLogHistoryRunListener.class.getName()).log(Level.WARNING, "changelog-history failure", ex);
        }
    }

    private void copyChangeLogs(AbstractBuild build) throws IOException, BuildException {
        File changeHistory;
        AbstractBuild nextBuild = (AbstractBuild)build.getNextBuild();
        if (nextBuild == null) {
            return;
        }
        File baseDir = new File(nextBuild.getRootDir(), "changelog-history");
        boolean copied = false;
        File changeLog = new File(build.getRootDir(), "changelog.xml");
        if (changeLog.isFile() && !build.getChangeSet().isEmptySet()) {
            this.checkDir(baseDir);
            Util.copyFile((File)changeLog, (File)new File(baseDir, build.getNumber() + ".xml"));
            copied = true;
        }
        if ((changeHistory = new File(build.getRootDir(), "changelog-history")).isDirectory()) {
            this.checkDir(baseDir);
            for (File file : changeHistory.listFiles()) {
                Util.copyFile((File)file, (File)new File(baseDir, file.getName()));
            }
            copied = true;
        }
        if (copied && nextBuild.getAction(ChangeLogHistoryAction.class) == null) {
            nextBuild.getActions().add(new ChangeLogHistoryAction(nextBuild));
            nextBuild.save();
        }
    }

    private void checkDir(File dir) throws IOException {
        if (!dir.isDirectory() && !dir.mkdir()) {
            throw new IOException("Failed to mkdir: " + dir);
        }
    }
}

