/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.model.AbstractBuild;
import hudson.plugins.checkstyle.util.AttributeDetail;
import hudson.plugins.checkstyle.util.ErrorDetail;
import hudson.plugins.checkstyle.util.FileDetail;
import hudson.plugins.checkstyle.util.FixedWarningsDetail;
import hudson.plugins.checkstyle.util.Messages;
import hudson.plugins.checkstyle.util.ModuleDetail;
import hudson.plugins.checkstyle.util.NewWarningsDetail;
import hudson.plugins.checkstyle.util.PackageDetail;
import hudson.plugins.checkstyle.util.PriorityDetailFactory;
import hudson.plugins.checkstyle.util.SourceDetail;
import hudson.plugins.checkstyle.util.TabDetail;
import hudson.plugins.checkstyle.util.model.AnnotationContainer;
import hudson.plugins.checkstyle.util.model.FileAnnotation;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailBuilder {
    public Object createTrendDetails(String link, AbstractBuild<?, ?> owner, AnnotationContainer container, Collection<FileAnnotation> fixedAnnotations, Collection<FileAnnotation> newAnnotations, Collection<String> errors, String displayName) {
        if ("fixed".equals(link)) {
            return new FixedWarningsDetail(owner, fixedAnnotations, displayName);
        }
        if ("new".equals(link)) {
            return new NewWarningsDetail(owner, newAnnotations, displayName);
        }
        if ("error".equals(link)) {
            return new ErrorDetail(owner, errors);
        }
        if (link.startsWith("tab.new")) {
            return new TabDetail(owner, newAnnotations, "/tabview/new.jelly");
        }
        if (link.startsWith("tab.fixed")) {
            return new TabDetail(owner, fixedAnnotations, "/tabview/fixed.jelly");
        }
        return this.createDetails(link, owner, container, displayName);
    }

    public Object createDetails(String link, AbstractBuild<?, ?> owner, AnnotationContainer container, String displayName) {
        PriorityDetailFactory factory = new PriorityDetailFactory();
        if (factory.isPriority(link)) {
            return factory.create(link, owner, container, displayName);
        }
        if (link.startsWith("module.")) {
            return new ModuleDetail(owner, container.getModule(StringUtils.substringAfter((String)link, (String)"module.")), displayName);
        }
        if (link.startsWith("package.")) {
            return new PackageDetail(owner, container.getPackage(StringUtils.substringAfter((String)link, (String)"package.")), displayName);
        }
        if (link.startsWith("file.")) {
            return new FileDetail(owner, container.getFile(Integer.valueOf(StringUtils.substringAfter((String)link, (String)"file.")).intValue()), displayName);
        }
        if (link.startsWith("tab.")) {
            return new TabDetail(owner, container.getAnnotations(), "/tabview/" + StringUtils.substringAfter((String)link, (String)"tab.") + ".jelly");
        }
        if (link.startsWith("source.")) {
            return new SourceDetail(owner, container.getAnnotation(StringUtils.substringAfter((String)link, (String)"source.")));
        }
        if (link.startsWith("category.")) {
            String category = StringUtils.substringAfter((String)link, (String)"category.");
            return new AttributeDetail(owner, (Collection)container.getCategory(category), displayName, Messages.CategoryDetail_header() + " " + category);
        }
        if (link.startsWith("type.")) {
            String type = StringUtils.substringAfter((String)link, (String)"type.");
            return new AttributeDetail(owner, (Collection)container.getType(type), displayName, Messages.TypeDetail_header() + " " + type);
        }
        return null;
    }
}

