/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.checkstyle.util.AbortException;
import hudson.plugins.checkstyle.util.HealthReportBuilder;
import hudson.plugins.checkstyle.util.ParserResult;
import hudson.plugins.checkstyle.util.TrendReportSize;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwareMavenReporter
extends MavenReporter {
    private static final long serialVersionUID = 3003791883748835331L;
    private final String threshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;
    private final String height;
    private final String pluginName;

    public HealthAwareMavenReporter(String threshold, String healthy, String unHealthy, String height, String pluginName) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.pluginName = "[" + pluginName + "] ";
        if (!StringUtils.isEmpty((String)threshold)) {
            try {
                this.minimumAnnotations = Integer.valueOf(threshold);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)healthy) && !StringUtils.isEmpty((String)unHealthy)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthy);
                this.unHealthyAnnotations = Integer.valueOf(unHealthy);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public final boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        if (!this.acceptGoal(mojo.getGoal())) {
            return true;
        }
        PrintStream logger = listener.getLogger();
        if (this.hasResultAction(build).booleanValue()) {
            this.log(logger, "Scipping maven reporter: there is already a result available.");
            return true;
        }
        try {
            ParserResult result = this.perform(build, pom, mojo, logger);
            build.execute((MavenBuildProxy.BuildCallable)new /* Unavailable Anonymous Inner Class!! */);
            this.evaluateBuildResult(build, logger, result);
        }
        catch (AbortException exception) {
            logger.println(exception.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    protected abstract boolean acceptGoal(String var1);

    protected abstract ParserResult perform(MavenBuildProxy var1, MavenProject var2, MojoInfo var3, PrintStream var4) throws InterruptedException, IOException;

    protected abstract void persistResult(ParserResult var1, MavenBuild var2);

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)this.pluginName) + message);
    }

    private void evaluateBuildResult(MavenBuildProxy build, PrintStream logger, ParserResult result) {
        int annotationCount = result.getAnnotations().size();
        if (annotationCount > 0) {
            this.log(logger, "A total of " + annotationCount + " annotations have been found.");
            if (this.isThresholdEnabled() && annotationCount >= this.getMinimumAnnotations()) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            this.log(logger, "No annotations have been found.");
        }
    }

    private Boolean hasResultAction(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Boolean)build.execute((MavenBuildProxy.BuildCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract Class<? extends Action> getResultActionClass();

    protected FilePath getTargetPath(MavenProject pom) {
        return new FilePath(new FilePath(pom.getBasedir()), "target");
    }

    protected HealthReportBuilder createHealthBuilder(String reportSingleCount, String reportMultipleCount) {
        return new HealthReportBuilder(this.isThresholdEnabled(), this.getMinimumAnnotations(), this.isHealthyReportEnabled(), this.getHealthyAnnotations(), this.getUnHealthyAnnotations(), reportSingleCount, reportMultipleCount);
    }

    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public String getHeight() {
        return this.height;
    }

    public int getTrendHeight() {
        return new TrendReportSize(this.height).getHeight();
    }
}

