/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.checkstyle.CheckStylePublisher;
import hudson.plugins.checkstyle.CheckStyleReporterDescriptor;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.CheckStyleResultBuilder;
import hudson.plugins.checkstyle.MavenCheckStyleResultAction;
import hudson.plugins.checkstyle.Messages;
import hudson.plugins.checkstyle.parser.CheckStyleParser;
import hudson.plugins.checkstyle.util.AnnotationParser;
import hudson.plugins.checkstyle.util.FilesParser;
import hudson.plugins.checkstyle.util.HealthAwareMavenReporter;
import hudson.plugins.checkstyle.util.HealthReportBuilder;
import hudson.plugins.checkstyle.util.ParserResult;
import hudson.plugins.checkstyle.util.PluginDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStyleReporter
extends HealthAwareMavenReporter {
    private static final long serialVersionUID = 2272875032054063496L;
    public static final CheckStyleReporterDescriptor CHECKSTYLE_SCANNER_DESCRIPTOR = new CheckStyleReporterDescriptor((PluginDescriptor)CheckStylePublisher.CHECKSTYLE_DESCRIPTOR);
    private static final String CHECKSTYLE_XML_FILE = "checkstyle-result.xml";

    @DataBoundConstructor
    public CheckStyleReporter(String threshold, String healthy, String unHealthy, String height, String thresholdLimit) {
        super(threshold, healthy, unHealthy, height, thresholdLimit, "CHECKSTYLE");
    }

    protected boolean acceptGoal(String goal) {
        return "checkstyle".equals(goal) || "site".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PrintStream logger) throws InterruptedException, IOException {
        FilesParser checkstyleCollector = new FilesParser(logger, CHECKSTYLE_XML_FILE, (AnnotationParser)new CheckStyleParser(), true, false);
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)checkstyleCollector);
    }

    protected void persistResult(ParserResult project, MavenBuild build) {
        CheckStyleResult result = new CheckStyleResultBuilder().build((AbstractBuild)build, project);
        HealthReportBuilder healthReportBuilder = this.createHealthBuilder(Messages.Checkstyle_ResultAction_HealthReportSingleItem(), Messages.Checkstyle_ResultAction_HealthReportMultipleItem());
        build.getActions().add(new MavenCheckStyleResultAction((AbstractBuild)build, healthReportBuilder, this.getHeight(), result));
        build.registerAsProjectAction((MavenReporter)this);
    }

    public Action getProjectAction(MavenModule module) {
        return new CheckStyleProjectAction((AbstractProject)module, this.getTrendHeight());
    }

    protected Class<? extends Action> getResultActionClass() {
        return MavenCheckStyleResultAction.class;
    }

    public MavenReporterDescriptor getDescriptor() {
        return CHECKSTYLE_SCANNER_DESCRIPTOR;
    }
}

