/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util.model;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.checkstyle.util.Messages;
import hudson.plugins.checkstyle.util.model.AnnotationProvider;
import hudson.plugins.checkstyle.util.model.DefaultAnnotationContainer;
import hudson.plugins.checkstyle.util.model.FileAnnotation;
import hudson.plugins.checkstyle.util.model.JavaPackage;
import hudson.plugins.checkstyle.util.model.MavenModule;
import hudson.plugins.checkstyle.util.model.Priority;
import hudson.plugins.checkstyle.util.model.WorkspaceFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationContainer
implements AnnotationProvider,
Serializable {
    private static final long serialVersionUID = 855696821788264261L;
    @SuppressWarnings(value={"Se"})
    private final Map<Long, FileAnnotation> annotations = new HashMap<Long, FileAnnotation>();
    private transient Map<Priority, Set<FileAnnotation>> annotationsByPriority;
    private transient Map<String, Set<FileAnnotation>> annotationsByCategory;
    private transient Map<String, Set<FileAnnotation>> annotationsByType;
    private transient Map<Integer, WorkspaceFile> filesByHashCode;
    private transient Map<String, WorkspaceFile> filesByName;
    private transient Map<String, JavaPackage> packagesByName;
    private transient Map<String, MavenModule> modulesByName;
    private boolean handleFiles;
    private String name;
    private Hierarchy hierarchy;

    public AnnotationContainer(Hierarchy hierarchy) {
        this("", hierarchy);
    }

    public AnnotationContainer getContainer() {
        return this;
    }

    protected AnnotationContainer(String name, Hierarchy hierarchy) {
        this.initialize();
        this.name = name;
        this.hierarchy = hierarchy;
    }

    protected void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    private void initialize() {
        this.annotationsByPriority = new EnumMap<Priority, Set<FileAnnotation>>(Priority.class);
        for (Priority priority : Priority.values()) {
            this.annotationsByPriority.put(priority, new HashSet());
        }
        this.annotationsByCategory = new HashMap<String, Set<FileAnnotation>>();
        this.annotationsByType = new HashMap<String, Set<FileAnnotation>>();
        this.filesByName = new HashMap<String, WorkspaceFile>();
        this.filesByHashCode = new HashMap<Integer, WorkspaceFile>();
        this.packagesByName = new HashMap<String, JavaPackage>();
        this.modulesByName = new HashMap<String, MavenModule>();
    }

    @SuppressWarnings(value={"Se"})
    private Object readResolve() {
        this.rebuildMappings();
        return this;
    }

    protected void rebuildMappings() {
        this.initialize();
        for (FileAnnotation annotation : this.getAnnotations()) {
            this.updateMappings(annotation);
        }
    }

    private void updateMappings(FileAnnotation annotation) {
        this.annotationsByPriority.get((Object)annotation.getPriority()).add(annotation);
        if (StringUtils.isNotBlank((String)annotation.getCategory())) {
            this.addCategory(annotation);
        }
        if (StringUtils.isNotBlank((String)annotation.getType())) {
            this.addType(annotation);
        }
        if (this.hierarchy == Hierarchy.PROJECT) {
            this.addModule(annotation);
        }
        if (this.hierarchy == Hierarchy.PROJECT || this.hierarchy == Hierarchy.MODULE) {
            this.addPackage(annotation);
        }
        if (this.hierarchy == Hierarchy.PROJECT || this.hierarchy == Hierarchy.MODULE || this.hierarchy == Hierarchy.PACKAGE) {
            this.addFile(annotation);
        }
    }

    private void addCategory(FileAnnotation annotation) {
        String category = annotation.getCategory();
        if (!this.annotationsByCategory.containsKey(category)) {
            this.annotationsByCategory.put(category, new HashSet());
        }
        this.annotationsByCategory.get(category).add(annotation);
    }

    private void addType(FileAnnotation annotation) {
        String type = annotation.getType();
        if (!this.annotationsByType.containsKey(type)) {
            this.annotationsByType.put(type, new HashSet());
        }
        this.annotationsByType.get(type).add(annotation);
    }

    private void addModule(FileAnnotation annotation) {
        String moduleName = annotation.getModuleName();
        if (!this.modulesByName.containsKey(moduleName)) {
            this.modulesByName.put(moduleName, new MavenModule(moduleName));
        }
        this.modulesByName.get(moduleName).addAnnotation(annotation);
    }

    private void addPackage(FileAnnotation annotation) {
        String packageName = annotation.getPackageName();
        if (!this.packagesByName.containsKey(packageName)) {
            this.packagesByName.put(packageName, new JavaPackage(packageName));
        }
        this.packagesByName.get(packageName).addAnnotation(annotation);
    }

    private void addFile(FileAnnotation annotation) {
        String fileName = annotation.getFileName();
        if (!this.filesByName.containsKey(fileName)) {
            WorkspaceFile file = new WorkspaceFile(fileName);
            this.filesByName.put(fileName, file);
            this.filesByHashCode.put(file.getName().hashCode(), file);
        }
        this.filesByName.get(fileName).addAnnotation(annotation);
    }

    public final void addAnnotation(FileAnnotation annotation) {
        this.annotations.put(annotation.getKey(), annotation);
        this.updateMappings(annotation);
    }

    public final void addAnnotations(Collection<? extends FileAnnotation> newAnnotations) {
        for (FileAnnotation fileAnnotation : newAnnotations) {
            this.addAnnotation(fileAnnotation);
        }
    }

    public final void addAnnotations(FileAnnotation[] newAnnotations) {
        this.addAnnotations(Arrays.asList(newAnnotations));
    }

    @Override
    public final Collection<FileAnnotation> getAnnotations() {
        return Collections.unmodifiableCollection(this.annotations.values());
    }

    @Override
    public final Collection<FileAnnotation> getAnnotations(Priority priority) {
        return Collections.unmodifiableCollection((Collection)this.annotationsByPriority.get((Object)priority));
    }

    public final Collection<FileAnnotation> getHighAnnotations() {
        return this.getAnnotations(Priority.HIGH);
    }

    public final Collection<FileAnnotation> getNormalAnnotations() {
        return this.getAnnotations(Priority.NORMAL);
    }

    public final Collection<FileAnnotation> getLowAnnotations() {
        return this.getAnnotations(Priority.LOW);
    }

    @Override
    public final Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getAnnotations(this.getPriority(priority));
    }

    private Priority getPriority(String priority) {
        return Priority.fromString(priority);
    }

    @Override
    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    @Override
    public int getNumberOfAnnotations(Priority priority) {
        return this.annotationsByPriority.get((Object)priority).size();
    }

    @Override
    public final int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(this.getPriority(priority));
    }

    @Override
    public final boolean hasAnnotations() {
        return !this.hasNoAnnotations();
    }

    @Override
    public final boolean hasAnnotations(Priority priority) {
        return !this.hasNoAnnotations(priority);
    }

    @Override
    public final boolean hasAnnotations(String priority) {
        return !this.hasNoAnnotations(priority);
    }

    @Override
    public final boolean hasNoAnnotations() {
        return this.annotations.isEmpty();
    }

    @Override
    public final boolean hasNoAnnotations(Priority priority) {
        return this.annotationsByPriority.get((Object)priority).isEmpty();
    }

    @Override
    public final boolean hasNoAnnotations(String priority) {
        return this.hasNoAnnotations(this.getPriority(priority));
    }

    @Override
    public final FileAnnotation getAnnotation(long key) {
        FileAnnotation annotation = this.annotations.get(key);
        if (annotation != null) {
            return annotation;
        }
        throw new NoSuchElementException("Annotation not found: key=" + key);
    }

    @Override
    public final FileAnnotation getAnnotation(String key) {
        return this.getAnnotation(Long.parseLong(key));
    }

    public String getToolTip() {
        StringBuilder message = new StringBuilder();
        for (Priority priority : Priority.values()) {
            if (!this.hasAnnotations(priority)) continue;
            message.append(priority.getLocalizedString());
            message.append(":");
            message.append(this.getNumberOfAnnotations(priority));
            message.append(" - ");
        }
        return StringUtils.removeEnd((String)message.toString(), (String)" - ");
    }

    public final String getPackageCategoryName() {
        String fileName;
        if (this.hasAnnotations() && (fileName = this.getAnnotations().iterator().next().getFileName()).endsWith(".cs")) {
            return Messages.NamespaceDetail_header();
        }
        return Messages.PackageDetail_header();
    }

    public Collection<MavenModule> getModules() {
        return Collections.unmodifiableCollection(this.modulesByName.values());
    }

    public boolean containsModule(String moduleName) {
        return this.modulesByName.containsKey(moduleName);
    }

    public MavenModule getModule(String moduleName) {
        if (this.modulesByName.containsKey(moduleName)) {
            return this.modulesByName.get(moduleName);
        }
        throw new NoSuchElementException("Module not found: " + moduleName);
    }

    public Collection<JavaPackage> getPackages() {
        return Collections.unmodifiableCollection(this.packagesByName.values());
    }

    public boolean containsPackage(String packageName) {
        return this.packagesByName.containsKey(packageName);
    }

    public JavaPackage getPackage(String packageName) {
        if (this.packagesByName.containsKey(packageName)) {
            return this.packagesByName.get(packageName);
        }
        throw new NoSuchElementException("Package not found: " + packageName);
    }

    public Collection<WorkspaceFile> getFiles() {
        return Collections.unmodifiableCollection(this.filesByName.values());
    }

    public boolean containsFile(String fileName) {
        return this.filesByName.containsKey(fileName);
    }

    public WorkspaceFile getFile(String fileName) {
        if (this.filesByName.containsKey(fileName)) {
            return this.filesByName.get(fileName);
        }
        throw new NoSuchElementException("File not found: " + fileName);
    }

    public WorkspaceFile getFile(int hashCode) {
        if (this.filesByHashCode.containsKey(hashCode)) {
            return this.filesByHashCode.get(hashCode);
        }
        throw new NoSuchElementException("File not found: " + hashCode);
    }

    public Collection<AnnotationContainer> getCategories() {
        ArrayList<AnnotationContainer> categories = new ArrayList<AnnotationContainer>();
        for (String category : this.annotationsByCategory.keySet()) {
            categories.add(this.getCategory(category));
        }
        return categories;
    }

    public boolean containsCategory(String category) {
        return this.annotationsByCategory.containsKey(category);
    }

    public DefaultAnnotationContainer getCategory(String category) {
        if (this.annotationsByCategory.containsKey(category)) {
            return new DefaultAnnotationContainer(category, (Collection<FileAnnotation>)this.annotationsByCategory.get(category));
        }
        throw new NoSuchElementException("Category not found: " + category);
    }

    public Collection<AnnotationContainer> getTypes() {
        ArrayList<AnnotationContainer> types = new ArrayList<AnnotationContainer>();
        for (String type : this.annotationsByType.keySet()) {
            types.add(this.getType(type));
        }
        return types;
    }

    public boolean containsType(String type) {
        return this.annotationsByType.containsKey(type);
    }

    public DefaultAnnotationContainer getType(String type) {
        if (this.annotationsByType.containsKey(type)) {
            return new DefaultAnnotationContainer(type, (Collection<FileAnnotation>)this.annotationsByType.get(type));
        }
        throw new NoSuchElementException("Type not found: " + type);
    }

    public Priority getHighPriority() {
        return Priority.HIGH;
    }

    public Priority getNormalPriority() {
        return Priority.NORMAL;
    }

    public Priority getLowPriority() {
        return Priority.LOW;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hierarchy {
        PROJECT,
        MODULE,
        PACKAGE,
        FILE;

    }
}

