/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.parser;

import hudson.plugins.checkstyle.parser.CheckStyle;
import hudson.plugins.checkstyle.parser.Error;
import hudson.plugins.checkstyle.parser.File;
import hudson.plugins.checkstyle.parser.Warning;
import hudson.plugins.checkstyle.util.AnnotationParser;
import hudson.plugins.checkstyle.util.JavaPackageDetector;
import hudson.plugins.checkstyle.util.model.FileAnnotation;
import hudson.plugins.checkstyle.util.model.Priority;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStyleParser
implements AnnotationParser {
    private static final long serialVersionUID = -8705621875291182458L;

    @Override
    public Collection<FileAnnotation> parse(java.io.File file, String moduleName) throws InvocationTargetException {
        try {
            return this.parse(new FileInputStream(file), moduleName);
        }
        catch (FileNotFoundException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public Collection<FileAnnotation> parse(InputStream file, String moduleName) throws InvocationTargetException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(CheckStyleParser.class.getClassLoader());
            String rootXPath = "checkstyle";
            digester.addObjectCreate(rootXPath, CheckStyle.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "checkstyle/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "checkstyle/file/error";
            digester.addObjectCreate(bugXPath, Error.class);
            digester.addSetProperties(bugXPath);
            digester.addSetNext(bugXPath, "addError", Error.class.getName());
            CheckStyle module = (CheckStyle)digester.parse(file);
            if (module == null) {
                throw new SAXException("Input stream is not a Checkstyle file.");
            }
            return this.convert(module, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private Collection<FileAnnotation> convert(CheckStyle collection, String moduleName) {
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        for (File file : collection.getFiles()) {
            String packageName = new JavaPackageDetector().detectPackageName(file.getName());
            for (Error error : file.getErrors()) {
                Priority priority;
                if ("error".equalsIgnoreCase(error.getSeverity())) {
                    priority = Priority.HIGH;
                } else if ("warning".equalsIgnoreCase(error.getSeverity())) {
                    priority = Priority.NORMAL;
                } else {
                    if (!"info".equalsIgnoreCase(error.getSeverity())) continue;
                    priority = Priority.LOW;
                }
                String source = error.getSource();
                String type = StringUtils.substringAfterLast((String)source, (String)".");
                String category = StringUtils.substringAfterLast((String)StringUtils.substringBeforeLast((String)source, (String)"."), (String)".");
                Warning warning = new Warning(priority, error.getMessage(), StringUtils.capitalize((String)category), type, error.getLine(), error.getLine());
                warning.setModuleName(moduleName);
                warning.setFileName(file.getName());
                warning.setPackageName(packageName);
                annotations.add(warning);
            }
        }
        return annotations;
    }

    @Override
    public String getName() {
        return "CHECKSTYLE";
    }
}

