/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util.model;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.checkstyle.util.model.AnnotationContainer;
import hudson.plugins.checkstyle.util.model.FileAnnotation;
import hudson.plugins.checkstyle.util.model.JavaPackage;
import hudson.plugins.checkstyle.util.model.MavenModule;
import hudson.plugins.checkstyle.util.model.WorkspaceFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProject
extends AnnotationContainer {
    private static final long serialVersionUID = 8556968267678442661L;
    @SuppressWarnings(value={"Se"})
    private final Map<String, MavenModule> moduleMapping = new HashMap();
    private String workspacePath;
    private boolean hasModuleError;
    private String error;

    private Object readResolve() {
        this.rebuildMappings(false);
        return this;
    }

    public void addFiles(Collection<WorkspaceFile> files) {
        for (WorkspaceFile workspaceFile : files) {
            this.addAnnotations(workspaceFile.getAnnotations());
        }
    }

    protected void annotationAdded(FileAnnotation annotation) {
        String moduleName = annotation.getModuleName();
        if (!this.moduleMapping.containsKey(moduleName)) {
            this.moduleMapping.put(moduleName, new MavenModule(moduleName));
        }
        ((MavenModule)this.moduleMapping.get(moduleName)).addAnnotation(annotation);
    }

    public Collection<MavenModule> getModules() {
        return Collections.unmodifiableCollection(this.moduleMapping.values());
    }

    public boolean containsModule(String moduleName) {
        return this.moduleMapping.get(moduleName) != null;
    }

    public MavenModule getModule(String moduleName) {
        MavenModule mavenModule = (MavenModule)this.moduleMapping.get(moduleName);
        if (mavenModule != null) {
            return mavenModule;
        }
        throw new NoSuchElementException("Module not found: " + moduleName);
    }

    public Collection<JavaPackage> getPackages() {
        ArrayList<JavaPackage> packages = new ArrayList<JavaPackage>();
        for (MavenModule module : this.moduleMapping.values()) {
            packages.addAll(module.getPackages());
        }
        return packages;
    }

    public JavaPackage getPackage(String name) {
        return this.getSingleModule().getPackage(name);
    }

    public Collection<WorkspaceFile> getFiles() {
        ArrayList<WorkspaceFile> files = new ArrayList<WorkspaceFile>();
        for (MavenModule module : this.moduleMapping.values()) {
            files.addAll(module.getFiles());
        }
        return files;
    }

    public WorkspaceFile getFile(String name) {
        return this.getSingleModule().getFile(name);
    }

    private MavenModule getSingleModule() {
        if (this.moduleMapping.size() != 1) {
            throw new IllegalArgumentException("Number of modules != 1");
        }
        return (MavenModule)this.moduleMapping.values().iterator().next();
    }

    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public int getAnnotationBound() {
        int tasks = 0;
        for (MavenModule module : this.moduleMapping.values()) {
            tasks = Math.max(tasks, module.getNumberOfAnnotations());
        }
        return tasks;
    }

    public void addModule(MavenModule module) {
        this.moduleMapping.put(module.getName(), module);
        this.addAnnotations(module.getAnnotations());
        if (module.hasError()) {
            this.hasModuleError = true;
        }
    }

    public void addModules(Collection<MavenModule> modules) {
        for (MavenModule mavenModule : modules) {
            this.addModule(mavenModule);
        }
    }

    public boolean hasError() {
        return this.hasModuleError || this.error != null;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }
}

