/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util.model;

import hudson.plugins.checkstyle.util.model.AnnotationContainer;
import hudson.plugins.checkstyle.util.model.MavenModule;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProject
extends AnnotationContainer {
    private static final long serialVersionUID = 8556968267678442661L;
    private String workspacePath;
    private boolean hasModuleError;
    private String error;

    public JavaProject() {
        super(AnnotationContainer.Hierarchy.PROJECT);
    }

    private Object readResolve() {
        this.setHierarchy(AnnotationContainer.Hierarchy.PROJECT);
        this.rebuildMappings();
        return this;
    }

    public void addModule(MavenModule module) {
        this.addAnnotations(module.getAnnotations());
        if (module.hasError()) {
            this.hasModuleError = true;
            this.addError(module.getError());
        }
    }

    public void addModules(Collection<MavenModule> modules) {
        for (MavenModule mavenModule : modules) {
            this.addModule(mavenModule);
        }
    }

    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public boolean hasError() {
        return this.hasModuleError || this.error != null;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void addError(String additionalError) {
        this.error = StringUtils.isEmpty((String)this.error) ? additionalError : this.error + "\n" + additionalError;
    }

    public String getError() {
        return this.error;
    }

    @Override
    protected Collection<? extends AnnotationContainer> getChildren() {
        return this.getModules();
    }
}

