/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util.model;

import hudson.plugins.checkstyle.util.model.AnnotationContainer;
import hudson.plugins.checkstyle.util.model.MavenModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProject
extends AnnotationContainer {
    private static final long serialVersionUID = 8556968267678442661L;
    private String workspacePath;
    private String error;
    private final List<String> moduleErrors = new ArrayList<String>();

    public JavaProject() {
        super(AnnotationContainer.Hierarchy.PROJECT);
    }

    private Object readResolve() {
        this.setHierarchy(AnnotationContainer.Hierarchy.PROJECT);
        this.rebuildMappings();
        return this;
    }

    public void addModule(MavenModule module) {
        this.addAnnotations(module.getAnnotations());
        if (module.hasError()) {
            this.moduleErrors.add(module.getError());
        }
    }

    public void addModules(Collection<MavenModule> modules) {
        for (MavenModule mavenModule : modules) {
            this.addModule(mavenModule);
        }
    }

    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public boolean hasError() {
        return this.moduleErrors.size() > 0 || this.error != null;
    }

    public void setError(String error) {
        this.error = error;
    }

    public List<String> getErrors() {
        ArrayList<String> allErrors = new ArrayList<String>();
        if (this.error != null) {
            allErrors.add(this.error);
        }
        allErrors.addAll(this.moduleErrors);
        return allErrors;
    }

    @Override
    protected Collection<? extends AnnotationContainer> getChildren() {
        return this.getModules();
    }
}

