/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.checkstyle.CheckStyleDescriptor;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.checkstyle.CheckStyleResultBuilder;
import hudson.plugins.checkstyle.Messages;
import hudson.plugins.checkstyle.parser.CheckStyleParser;
import hudson.plugins.checkstyle.util.FilesParser;
import hudson.plugins.checkstyle.util.HealthAwarePublisher;
import hudson.plugins.checkstyle.util.HealthReportBuilder;
import hudson.plugins.checkstyle.util.model.JavaProject;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStylePublisher
extends HealthAwarePublisher {
    private static final String DEFAULT_PATTERN = "**/checkstyle-result.xml";
    public static final CheckStyleDescriptor CHECKSTYLE_DESCRIPTOR = new CheckStyleDescriptor();
    private final String pattern;

    @DataBoundConstructor
    public CheckStylePublisher(String pattern, String threshold, String healthy, String unHealthy, String height) {
        super(threshold, healthy, unHealthy, height, "CHECKSTYLE");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CheckStyleProjectAction(project, this.getTrendHeight());
    }

    @Override
    public JavaProject perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        this.log(logger, "Collecting checkstyle analysis files...");
        FilesParser parser = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), new CheckStyleParser());
        JavaProject project = (JavaProject)build.getProject().getWorkspace().act((FilePath.FileCallable)parser);
        CheckStyleResult result = new CheckStyleResultBuilder().build(build, project);
        HealthReportBuilder healthReportBuilder = this.createHealthReporter(Messages.Checkstyle_ResultAction_HealthReportSingleItem(), Messages.Checkstyle_ResultAction_HealthReportMultipleItem("%d"));
        build.getActions().add(new CheckStyleResultAction(build, healthReportBuilder, result));
        return project;
    }

    public Descriptor<Publisher> getDescriptor() {
        return CHECKSTYLE_DESCRIPTOR;
    }
}

