/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.plugins.checkstyle.util.Messages;
import hudson.plugins.checkstyle.util.SingleFieldValidator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingValidator
extends SingleFieldValidator {
    private static final Set<String> ALL_CHARSETS = Collections.unmodifiableSet(new HashSet<String>(Charset.availableCharsets().keySet()));

    public EncodingValidator(StaplerRequest request, StaplerResponse response) {
        super(request, response);
    }

    public static Set<String> getAvailableCharsets() {
        return ALL_CHARSETS;
    }

    public static Charset defaultCharset(String defaultEncoding) {
        try {
            if (StringUtils.isNotBlank((String)defaultEncoding)) {
                return Charset.forName(defaultEncoding);
            }
        }
        catch (UnsupportedCharsetException exception) {
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return Charset.defaultCharset();
    }

    public void check(String encoding) throws IOException, ServletException {
        try {
            if (StringUtils.isEmpty((String)encoding) || Charset.forName(encoding) != null) {
                this.ok();
            }
        }
        catch (IllegalCharsetNameException exception) {
            this.error(Messages.FieldValidator_Error_DefaultEncoding());
        }
        catch (UnsupportedCharsetException exception) {
            this.error(Messages.FieldValidator_Error_DefaultEncoding());
        }
    }
}

