/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.plugins.checkstyle.util.FileFinder;
import hudson.plugins.checkstyle.util.FileInputStreamFactory;
import hudson.plugins.checkstyle.util.ModuleDetector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDetector {
    protected static final String MAVEN_POM = "pom.xml";
    protected static final String ANT_PROJECT = "build.xml";
    private static final String TARGET = "/target";
    private FileInputStreamFactory factory = new DefaultFileInputStreamFactory(null);
    private final Map<String, String> fileNameToModuleName;
    private final List<String> prefixes;

    public ModuleDetector() {
        this.fileNameToModuleName = new HashMap();
        this.prefixes = new ArrayList();
    }

    public ModuleDetector(File workspace) {
        this(workspace, (FileInputStreamFactory)new DefaultFileInputStreamFactory(null));
    }

    public ModuleDetector(File workspace, FileInputStreamFactory fileInputStreamFactory) {
        this.setFileInputStreamFactory(fileInputStreamFactory);
        this.fileNameToModuleName = this.createFilesToModuleMapping(workspace);
        this.prefixes = new ArrayList(this.fileNameToModuleName.keySet());
        Collections.sort(this.prefixes);
    }

    public void setFileInputStreamFactory(FileInputStreamFactory fileInputStreamFactory) {
        this.factory = fileInputStreamFactory;
    }

    private Map<String, String> createFilesToModuleMapping(File workspace) {
        String moduleName;
        String fileName;
        int i;
        String[] projects = this.findMavenModules(workspace);
        HashMap<String, String> mapping = new HashMap<String, String>();
        if (projects.length > 0) {
            for (i = 0; i < projects.length; ++i) {
                fileName = projects[i];
                moduleName = this.parsePom(fileName);
                if (!StringUtils.isNotBlank((String)moduleName)) continue;
                mapping.put(StringUtils.substringBeforeLast((String)fileName, (String)MAVEN_POM), moduleName);
            }
        }
        if (mapping.isEmpty()) {
            projects = this.findAntProjects(workspace);
            for (i = 0; i < projects.length; ++i) {
                fileName = projects[i];
                moduleName = this.parseBuildXml(fileName);
                if (!StringUtils.isNotBlank((String)moduleName)) continue;
                mapping.put(StringUtils.substringBeforeLast((String)fileName, (String)ANT_PROJECT), moduleName);
            }
        }
        return mapping;
    }

    public String guessModuleName(String originalFileName) {
        String fullPath = originalFileName.replace('\\', '/');
        String guessedModule = "";
        for (String path : this.prefixes) {
            if (!fullPath.startsWith(path)) continue;
            guessedModule = (String)this.fileNameToModuleName.get(path);
        }
        return guessedModule;
    }

    private String[] findMavenModules(File workspace) {
        return this.find(workspace, "**/pom.xml");
    }

    private String[] findAntProjects(File workspace) {
        return this.find(workspace, "**/build.xml");
    }

    protected String[] find(File path, String pattern) {
        String[] relativeFileNames = new FileFinder(pattern).find(path);
        String[] absoluteFileNames = new String[relativeFileNames.length];
        String absolutePath = path.getAbsolutePath();
        for (int file = 0; file < absoluteFileNames.length; ++file) {
            absoluteFileNames[file] = (absolutePath + "/" + relativeFileNames[file]).replace("\\", "/");
        }
        return absoluteFileNames;
    }

    public String guessModuleName(String fileName, boolean isMavenBuild, boolean isAntBuild) {
        String projectName;
        String projectName2;
        String unixName = fileName.replace("\\", "/");
        if (isMavenBuild && StringUtils.isNotBlank((String)(projectName2 = this.parsePom(unixName)))) {
            return projectName2;
        }
        String path = StringUtils.substringBeforeLast((String)unixName, (String)"/");
        if (isAntBuild && StringUtils.isNotBlank((String)(projectName = this.parseBuildXml(path)))) {
            return projectName;
        }
        if (path.contains("/")) {
            return StringUtils.substringAfterLast((String)path, (String)"/");
        }
        return path;
    }

    private String parseBuildXml(String path) {
        try {
            String fileName = StringUtils.isBlank((String)path) ? ANT_PROJECT : path + "/build.xml";
            InputStream pom = this.factory.create(fileName);
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(ModuleDetector.class.getClassLoader());
            digester.push((Object)new StringBuffer());
            String xPath = "project";
            digester.addCallMethod(xPath, "append", 1);
            digester.addCallParam(xPath, 0, "name");
            StringBuffer result = (StringBuffer)digester.parse(pom);
            return result.toString();
        }
        catch (IOException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return "";
    }

    private String parsePom(String fileName) {
        try {
            InputStream pom = null;
            if (fileName.endsWith(MAVEN_POM)) {
                pom = this.factory.create(fileName);
            } else if (fileName.contains(TARGET)) {
                String module = StringUtils.substringBeforeLast((String)fileName, (String)TARGET);
                pom = this.factory.create(module + "/pom.xml");
            }
            if (pom != null) {
                Digester digester = new Digester();
                digester.setValidating(false);
                digester.setClassLoader(ModuleDetector.class.getClassLoader());
                digester.push((Object)new StringBuffer());
                digester.addCallMethod("project/name", "append", 0);
                StringBuffer result = (StringBuffer)digester.parse(pom);
                return result.toString();
            }
        }
        catch (IOException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return "";
    }
}

