/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.plugins.checkstyle.util.BuildResult;
import hudson.plugins.checkstyle.util.BuildResultGraph;
import hudson.plugins.checkstyle.util.CategoryUrlBuilder;
import hudson.plugins.checkstyle.util.GraphConfiguration;
import hudson.plugins.checkstyle.util.Pair;
import hudson.plugins.checkstyle.util.ResultAction;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceGraph
extends BuildResultGraph {
    @Override
    public JFreeChart create(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction, String pluginName) {
        ArrayList<Pair<Integer, Integer>> fixedWarnings = new ArrayList<Pair<Integer, Integer>>();
        ArrayList<Pair<Integer, Integer>> newWarnings = new ArrayList<Pair<Integer, Integer>>();
        this.extractPoints(configuration, resultAction, fixedWarnings, newWarnings);
        XYSeriesCollection xySeriesCollection = this.computeDifferenceSeries(fixedWarnings, newWarnings);
        JFreeChart chart = this.createXYChart((XYDataset)xySeriesCollection);
        chart.getXYPlot().getRenderer().setURLGenerator((XYURLGenerator)new XyUrlBuilder(this.getRootUrl(), pluginName));
        NumberAxis axis = new NumberAxis();
        axis.setVerticalTickLabels(true);
        axis.setNumberFormatOverride((NumberFormat)new HudsonBuildFormat());
        axis.setAutoRange(true);
        axis.setAutoRangeIncludesZero(false);
        axis.setLowerMargin(0.0);
        axis.setUpperMargin(0.0);
        chart.getXYPlot().setDomainAxis((ValueAxis)axis);
        return chart;
    }

    private XYSeriesCollection computeDifferenceSeries(ArrayList<Pair<Integer, Integer>> fixedWarnings, ArrayList<Pair<Integer, Integer>> newWarnings) {
        XYSeries fixedSeries = new XYSeries((Comparable)((Object)"fixed"));
        XYSeries newSeries = new XYSeries((Comparable)((Object)"new"));
        int fixedCount = 0;
        int newCount = 0;
        for (int i = 0; i < fixedWarnings.size(); ++i) {
            Pair<Integer, Integer> point = fixedWarnings.get(i);
            int build = point.getHead();
            fixedCount += point.getTail().intValue();
            point = newWarnings.get(i);
            fixedSeries.add((double)build, (double)fixedCount);
            newSeries.add((double)build, (double)(newCount += point.getTail().intValue()));
        }
        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        xySeriesCollection.addSeries(fixedSeries);
        xySeriesCollection.addSeries(newSeries);
        return xySeriesCollection;
    }

    private void extractPoints(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction, ArrayList<Pair<Integer, Integer>> fixedWarnings, ArrayList<Pair<Integer, Integer>> newWarnings) {
        Calendar oldBuildTime;
        ResultAction<? extends BuildResult> action = resultAction;
        int buildCount = 0;
        Calendar buildTime = action.getBuild().getTimestamp();
        do {
            BuildResult current = action.getResult();
            int build = action.getBuild().getNumber();
            fixedWarnings.add(new Pair<Integer, Integer>(build, current.getNumberOfFixedWarnings()));
            newWarnings.add(new Pair<Integer, Integer>(build, current.getNumberOfNewWarnings()));
            if (!action.hasPreviousResultAction()) break;
            action = action.getPreviousResultAction();
        } while ((!configuration.isBuildCountDefined() || ++buildCount < configuration.getBuildCount()) && (!configuration.isDayCountDefined() || this.computeDayDelta(buildTime, oldBuildTime = action.getBuild().getTimestamp()) < (long)configuration.getDayCount()));
        Collections.reverse(fixedWarnings);
        Collections.reverse(newWarnings);
    }

    private static class XyUrlBuilder
    extends CategoryUrlBuilder
    implements XYURLGenerator {
        private static final long serialVersionUID = 7555399727715726510L;

        public XyUrlBuilder(String rootUrl, String pluginName) {
            super(rootUrl, pluginName);
        }

        public String generateURL(XYDataset dataset, int series, int item) {
            return this.getRootUrl() + (int)dataset.getXValue(series, item) + this.getPluginName();
        }
    }

    private static final class HudsonBuildFormat
    extends NumberFormat {
        private static final long serialVersionUID = 3487003853901042584L;

        private HudsonBuildFormat() {
        }

        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format((long)number, toAppendTo, pos);
        }

        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append("#");
            stringBuffer.append(number);
            return stringBuffer;
        }

        public Number parse(String source, ParsePosition parsePosition) {
            return null;
        }
    }
}

