/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.plugins.checkstyle.util.AbstractHealthDescriptor;
import hudson.plugins.checkstyle.util.BuildResult;
import hudson.plugins.checkstyle.util.DifferenceGraph;
import hudson.plugins.checkstyle.util.GraphConfiguration;
import hudson.plugins.checkstyle.util.HealthGraph;
import hudson.plugins.checkstyle.util.NewVersusFixedGraph;
import hudson.plugins.checkstyle.util.PriorityGraph;
import hudson.plugins.checkstyle.util.ResultAction;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GraphType {
    NONE{

        @Override
        public JFreeChart createGraph(GraphConfiguration configuration, AbstractHealthDescriptor healthDescriptor, ResultAction<? extends BuildResult> resultAction, String pluginName) {
            return PRIORITY.createGraph(configuration, healthDescriptor, resultAction, pluginName);
        }
    }
    ,
    PRIORITY{

        @Override
        public JFreeChart createGraph(GraphConfiguration configuration, AbstractHealthDescriptor healthDescriptor, ResultAction<? extends BuildResult> resultAction, String pluginName) {
            return new PriorityGraph().create(configuration, resultAction, pluginName);
        }
    }
    ,
    FIXED{

        @Override
        public JFreeChart createGraph(GraphConfiguration configuration, AbstractHealthDescriptor healthDescriptor, ResultAction<? extends BuildResult> resultAction, String pluginName) {
            return new NewVersusFixedGraph().create(configuration, resultAction, pluginName);
        }
    }
    ,
    DIFFERENCE{

        @Override
        public JFreeChart createGraph(GraphConfiguration configuration, AbstractHealthDescriptor healthDescriptor, ResultAction<? extends BuildResult> resultAction, String pluginName) {
            return new DifferenceGraph().create(configuration, resultAction, pluginName);
        }
    }
    ,
    HEALTH{

        @Override
        public JFreeChart createGraph(GraphConfiguration configuration, AbstractHealthDescriptor healthDescriptor, ResultAction<? extends BuildResult> resultAction, String pluginName) {
            if (healthDescriptor.isEnabled()) {
                return new HealthGraph(healthDescriptor).create(configuration, resultAction, pluginName);
            }
            return PRIORITY.createGraph(configuration, healthDescriptor, resultAction, pluginName);
        }
    };


    public abstract JFreeChart createGraph(GraphConfiguration var1, AbstractHealthDescriptor var2, ResultAction<? extends BuildResult> var3, String var4);

    public String getId() {
        return StringUtils.lowerCase((String)this.name());
    }
}

