/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.checkstyle.util.AbstractHealthDescriptor;
import hudson.plugins.checkstyle.util.AreaRenderer;
import hudson.plugins.checkstyle.util.BuildResult;
import hudson.plugins.checkstyle.util.CategoryBuildResultGraph;
import hudson.plugins.checkstyle.util.CategoryUrlBuilder;
import hudson.plugins.checkstyle.util.HealthGraph;
import hudson.plugins.checkstyle.util.SerializableToolTipGenerator;
import hudson.plugins.checkstyle.util.SerializableUrlGenerator;
import hudson.plugins.checkstyle.util.ToolTipProvider;
import hudson.util.ColorPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthGraph
extends CategoryBuildResultGraph {
    private final AbstractHealthDescriptor healthDescriptor;

    public HealthGraph(AbstractHealthDescriptor healthDescriptor) {
        this.healthDescriptor = healthDescriptor;
    }

    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>(3);
        int remainder = current.getNumberOfAnnotations();
        if (this.healthDescriptor.isHealthyReportEnabled()) {
            series.add(Math.min(remainder, this.healthDescriptor.getHealthyAnnotations()));
            int range = this.healthDescriptor.getUnHealthyAnnotations() - this.healthDescriptor.getHealthyAnnotations();
            if ((remainder -= this.healthDescriptor.getHealthyAnnotations()) > 0) {
                series.add(Math.min(remainder, range));
            } else {
                series.add(0);
            }
            if ((remainder -= range) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        } else if (this.healthDescriptor.isThresholdEnabled()) {
            series.add(Math.min(remainder, this.healthDescriptor.getMinimumAnnotations()));
            if ((remainder -= this.healthDescriptor.getMinimumAnnotations()) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        }
        return series;
    }

    protected JFreeChart createChart(CategoryDataset dataSet) {
        return this.createAreaChart(dataSet);
    }

    private boolean useThreeColors() {
        return this.healthDescriptor.isHealthyReportEnabled() || !this.healthDescriptor.isThresholdEnabled();
    }

    @SuppressWarnings(value={"SIC"})
    protected CategoryItemRenderer createRenderer(String pluginName, ToolTipProvider toolTipProvider) {
        CategoryUrlBuilder createUrlGenerator = new CategoryUrlBuilder(this.getRootUrl(), pluginName);
        1 createToolTipGenerator = new /* Unavailable Anonymous Inner Class!! */;
        return new AreaRenderer((SerializableUrlGenerator)createUrlGenerator, (SerializableToolTipGenerator)createToolTipGenerator);
    }

    protected Color[] getColors() {
        if (this.useThreeColors()) {
            return new Color[]{ColorPalette.BLUE, ColorPalette.YELLOW, ColorPalette.RED};
        }
        return new Color[]{ColorPalette.BLUE, ColorPalette.RED};
    }
}

