/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.checkstyle.util.AbortException;
import hudson.plugins.checkstyle.util.HealthDescriptor;
import hudson.plugins.checkstyle.util.ParserResult;
import hudson.plugins.checkstyle.util.TrendReportHeightValidator;
import hudson.plugins.checkstyle.util.model.DefaultAnnotationContainer;
import hudson.plugins.checkstyle.util.model.FileAnnotation;
import hudson.plugins.checkstyle.util.model.Priority;
import hudson.plugins.checkstyle.util.model.WorkspaceFile;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Ant;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwarePublisher
extends Publisher
implements HealthDescriptor {
    private static final long serialVersionUID = -7945220365563528457L;
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private final String threshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;
    private final String height;
    private final String pluginName;
    private String thresholdLimit;
    private final String defaultEncoding;

    public HealthAwarePublisher(String threshold, String healthy, String unHealthy, String height, String thresholdLimit, String defaultEncoding, String pluginName) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.thresholdLimit = thresholdLimit;
        this.defaultEncoding = defaultEncoding;
        this.pluginName = "[" + pluginName + "] ";
        this.validateThreshold(threshold);
        this.validateHealthiness(healthy, unHealthy);
        if (StringUtils.isBlank((String)thresholdLimit)) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
    }

    private void validateHealthiness(String healthyParameter, String unHealthyParameter) {
        if (!StringUtils.isEmpty((String)healthyParameter) && !StringUtils.isEmpty((String)unHealthyParameter)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthyParameter);
                this.unHealthyAnnotations = Integer.valueOf(unHealthyParameter);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void validateThreshold(String thresholdParameter) {
        if (!StringUtils.isEmpty((String)thresholdParameter)) {
            try {
                this.minimumAnnotations = Integer.valueOf(thresholdParameter);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        return this;
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.canContinue(build.getResult())) {
            PrintStream logger = listener.getLogger();
            try {
                ParserResult project = this.perform(build, logger);
                this.evaluateBuildResult(build, logger, project);
                if (build.getProject().getWorkspace().isRemote()) {
                    this.copyFilesFromSlaveToMaster(build.getRootDir(), launcher.getChannel(), project.getAnnotations());
                }
            }
            catch (AbortException exception) {
                logger.println(exception.getMessage());
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    private void copyFilesFromSlaveToMaster(File rootDir, VirtualChannel channel, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        File directory = new File(rootDir, "workspace-files");
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Can't create directory for workspace files that contain annotations: " + directory.getAbsolutePath());
        }
        DefaultAnnotationContainer container = new DefaultAnnotationContainer(annotations);
        for (WorkspaceFile file : container.getFiles()) {
            File masterFile = new File(directory, file.getTempName());
            if (masterFile.exists()) continue;
            FileOutputStream outputStream = new FileOutputStream(masterFile);
            try {
                new FilePath(channel, file.getName()).copyTo((OutputStream)outputStream);
            }
            catch (IOException exception) {
                String message = "Can't copy file from slave to master: slave=" + file.getName() + ", master=" + masterFile.getAbsolutePath();
                IOUtils.write((String)message, (OutputStream)outputStream);
                exception.printStackTrace(new PrintStream(outputStream));
                outputStream.close();
            }
        }
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    protected abstract ParserResult perform(AbstractBuild<?, ?> var1, PrintStream var2) throws InterruptedException, IOException;

    private void evaluateBuildResult(AbstractBuild<?, ?> build, PrintStream logger, ParserResult project) {
        int annotationCount = 0;
        for (Priority priority : Priority.collectPrioritiesFrom((Priority)this.getMinimumPriority())) {
            int numberOfAnnotations = project.getNumberOfAnnotations(priority);
            this.log(logger, "A total of " + numberOfAnnotations + " annotations have been found for priority " + priority);
            annotationCount += numberOfAnnotations;
        }
        if (annotationCount > 0 && this.isThresholdEnabled() && annotationCount >= this.getMinimumAnnotations()) {
            build.setResult(Result.UNSTABLE);
        }
    }

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)this.pluginName) + message);
    }

    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public String getHeight() {
        return this.height;
    }

    public int getTrendHeight() {
        return TrendReportHeightValidator.defaultHeight((String)this.height);
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    protected boolean isMavenBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Maven)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAntBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Ant)) continue;
                return true;
            }
        }
        return false;
    }

    public Priority getMinimumPriority() {
        return Priority.valueOf((String)StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }
}

