/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.plugins.checkstyle.util.HealthDescriptor;
import hudson.plugins.checkstyle.util.model.AnnotationProvider;
import hudson.plugins.checkstyle.util.model.Priority;
import org.jvnet.localizer.Localizable;

public abstract class AbstractHealthDescriptor
implements HealthDescriptor {
    private static final long serialVersionUID = -3709673381162699834L;
    private final boolean isFailureThresholdEnabled;
    private final int minimumAnnotations;
    private final int healthyAnnotations;
    private final int unHealthyAnnotations;
    private final boolean isHealthyReportEnabled;
    private final Priority priority;

    public AbstractHealthDescriptor(HealthDescriptor healthDescriptor) {
        this.isFailureThresholdEnabled = healthDescriptor.isThresholdEnabled();
        this.minimumAnnotations = healthDescriptor.getMinimumAnnotations();
        this.isHealthyReportEnabled = healthDescriptor.isHealthyReportEnabled();
        this.healthyAnnotations = healthDescriptor.getHealthyAnnotations();
        this.unHealthyAnnotations = healthDescriptor.getUnHealthyAnnotations();
        this.priority = healthDescriptor.getMinimumPriority();
    }

    public AbstractHealthDescriptor() {
        this.isFailureThresholdEnabled = false;
        this.isHealthyReportEnabled = false;
        this.minimumAnnotations = 0;
        this.healthyAnnotations = 0;
        this.unHealthyAnnotations = 0;
        this.priority = Priority.LOW;
    }

    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public boolean isHealthyReportEnabled() {
        return this.isHealthyReportEnabled;
    }

    public boolean isThresholdEnabled() {
        return this.isFailureThresholdEnabled;
    }

    public Priority getMinimumPriority() {
        return this.priority;
    }

    protected abstract Localizable createDescription(AnnotationProvider var1);
}

