/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle;

import hudson.model.AbstractBuild;
import hudson.plugins.checkstyle.CheckStyleResultAction;
import hudson.plugins.checkstyle.Messages;
import hudson.plugins.checkstyle.ResultSummary;
import hudson.plugins.checkstyle.parser.Warning;
import hudson.plugins.checkstyle.util.BuildResult;
import hudson.plugins.checkstyle.util.ParserResult;
import hudson.plugins.checkstyle.util.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CheckStyleResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public CheckStyleResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
    }

    public CheckStyleResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, CheckStyleResult previous) {
        super(build, defaultEncoding, result, (BuildResult)previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary((CheckStyleResult)this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage((CheckStyleResult)this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.Checkstyle_ResultAction_NoWarningsSince((Object)this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = CheckStyleResult.getDays((long)this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.Checkstyle_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.Checkstyle_ResultAction_MultipleHighScore((Object)days) + "</li>";
        }
        long days = CheckStyleResult.getDays((long)this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.Checkstyle_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.Checkstyle_ResultAction_MultipleNoHighScore((Object)days) + "</li>";
    }

    protected String getSerializationFileName() {
        return "checkstyle-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.Checkstyle_ProjectAction_Name();
    }

    protected JavaProject getPreviousResult() {
        CheckStyleResultAction action = (CheckStyleResultAction)this.getOwner().getAction(CheckStyleResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((CheckStyleResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return new JavaProject();
    }

    protected boolean hasPreviousResult() {
        return ((CheckStyleResultAction)this.getOwner().getAction(CheckStyleResultAction.class)).hasPreviousResultAction();
    }

    static {
        XSTREAM.alias("warning", Warning.class);
    }
}

