/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle.util;

import hudson.model.HealthReport;
import hudson.plugins.checkstyle.util.AbstractHealthDescriptor;
import hudson.plugins.checkstyle.util.ChartBuilder;
import hudson.plugins.checkstyle.util.PrioritiesAreaRenderer;
import hudson.plugins.checkstyle.util.ResultAreaRenderer;
import hudson.plugins.checkstyle.util.ToolTipProvider;
import hudson.plugins.checkstyle.util.model.AnnotationProvider;
import hudson.plugins.checkstyle.util.model.Priority;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthReportBuilder
implements Serializable {
    private static final long serialVersionUID = 5191317904662711835L;
    private final AbstractHealthDescriptor healthDescriptor;
    @Deprecated
    private int healthy;
    @Deprecated
    private int unHealthy;
    @Deprecated
    private boolean isHealthEnabled;
    @Deprecated
    private boolean isThresholdEnabled;
    @Deprecated
    private int threshold;
    @Deprecated
    private String reportName;
    @Deprecated
    private String itemName;
    @Deprecated
    private String reportSingleCount;
    @Deprecated
    private String reportMultipleCount;

    public HealthReportBuilder(AbstractHealthDescriptor healthDescriptor) {
        this.healthDescriptor = healthDescriptor;
    }

    public HealthReport computeHealth(AnnotationProvider result) {
        int numberOfAnnotations = 0;
        for (Priority priority : Priority.collectPrioritiesFrom((Priority)this.healthDescriptor.getMinimumPriority())) {
            numberOfAnnotations += result.getNumberOfAnnotations(priority);
        }
        return this.computeHealth(numberOfAnnotations, result);
    }

    protected HealthReport computeHealth(int counter, AnnotationProvider result) {
        if (this.healthDescriptor.isHealthyReportEnabled()) {
            int percentage = counter < this.healthDescriptor.getHealthyAnnotations() ? 100 : (counter > this.healthDescriptor.getUnHealthyAnnotations() ? 0 : 100 - (counter - this.healthDescriptor.getHealthyAnnotations()) * 100 / (this.healthDescriptor.getUnHealthyAnnotations() - this.healthDescriptor.getHealthyAnnotations()));
            return new HealthReport(percentage, this.healthDescriptor.createDescription(result));
        }
        return null;
    }

    public boolean isEnabled() {
        return this.healthDescriptor.isHealthyReportEnabled() || this.healthDescriptor.isThresholdEnabled();
    }

    public List<Integer> createSeries(int totalCount) {
        ArrayList<Integer> series = new ArrayList<Integer>(3);
        int remainder = totalCount;
        if (this.healthDescriptor.isHealthyReportEnabled()) {
            series.add(Math.min(remainder, this.healthDescriptor.getHealthyAnnotations()));
            int range = this.healthDescriptor.getUnHealthyAnnotations() - this.healthDescriptor.getHealthyAnnotations();
            if ((remainder -= this.healthDescriptor.getHealthyAnnotations()) > 0) {
                series.add(Math.min(remainder, range));
            } else {
                series.add(0);
            }
            if ((remainder -= range) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        } else if (this.healthDescriptor.isThresholdEnabled()) {
            series.add(Math.min(remainder, this.healthDescriptor.getMinimumAnnotations()));
            if ((remainder -= this.healthDescriptor.getMinimumAnnotations()) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        }
        return series;
    }

    public JFreeChart createGraph(boolean useHealthBuilder, String url, CategoryDataset dataset, ToolTipProvider toolTipProvider) {
        Object renderer = useHealthBuilder && this.isEnabled() ? new ResultAreaRenderer(url, toolTipProvider) : new PrioritiesAreaRenderer(url, toolTipProvider);
        return ChartBuilder.createChart((CategoryDataset)dataset, (StackedAreaRenderer)renderer, (int)this.healthDescriptor.getMinimumAnnotations(), (this.healthDescriptor.isHealthyReportEnabled() || !this.healthDescriptor.isThresholdEnabled() || !useHealthBuilder ? 1 : 0) != 0);
    }
}

